﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _602顧客検索 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public string mstr選択済み顧客No;

        public D10顧客.D10顧客検索DataTable dt顧客検索結果 = new D10顧客.D10顧客検索DataTable();

		//private enum enm顧客一覧Cell : int
		//{
		//    選択 = 0,
		//    顧客No = 1,
		//    顧客ID = 2,
		//    氏名 = 3,
		//    氏名カナ = 4,
		//    性別 = 5,
		//    生年月日 = 6,
		//    郵便番号 = 7,
		//    住所 = 8,
		//    TEL = 9,
		//    メールアドレス = 10,
		//    メルマガ許諾 = 11,
		//    備考 = 12
		//}
		private static class 顧客一覧Cell
		{
            public const byte byt選択 = 0;
            public const byte byt顧客No = 1;
            public const byte byt顧客ID = 2;
            public const byte byt氏名 = 3;
            public const byte byt氏名カナ = 4;
            public const byte byt性別 = 5;
            public const byte byt生年月日 = 6;
            public const byte byt郵便番号 = 7;
            public const byte byt住所 = 8;
            public const byte bytTEL = 9;
            public const byte bytメールアドレス = 10;
            public const byte bytメルマガ許諾 = 11;
			public const byte byt備考 = 12;
		}

        private class 検索条件
        {
            public string 顧客ID { get; set; }
            public string 氏名 { get; set; }
            public string 氏名カナ { get; set; }
            public Nullable<int> 性別 { get; set; }
            public Nullable<DateTime> 生年月日 { get; set; }
            public string 郵便番号 { get; set; }
            public string 住所 { get; set; }
            public string TEL { get; set; }
            public string メールアドレス { get; set; }
            public Nullable<int> メルマガ許諾 { get; set; }
        }

		//private 顧客分析君.D10顧客TableAdapters.D10顧客検索ta d10顧客検索ta;
		
		#endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _602顧客検索()
        {
            InitializeComponent();

			//this.d10顧客検索ta = new 顧客分析君.D10顧客TableAdapters.D10顧客検索ta();

			//this.d10顧客検索ta.ClearBeforeFill = true;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv顧客一覧.Columns[顧客一覧Cell.byt選択].Width = C_列幅.削除;
            dgv顧客一覧.Columns[顧客一覧Cell.byt顧客No].Visible = false;
            dgv顧客一覧.Columns[顧客一覧Cell.byt顧客ID].Width = C_列幅.顧客ID;
            dgv顧客一覧.Columns[顧客一覧Cell.byt氏名].Width = C_列幅.氏名;
            dgv顧客一覧.Columns[顧客一覧Cell.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgv顧客一覧.Columns[顧客一覧Cell.byt性別].Width = C_列幅.性別;
            dgv顧客一覧.Columns[顧客一覧Cell.byt生年月日].Width = C_列幅.年月日;
            dgv顧客一覧.Columns[顧客一覧Cell.byt郵便番号].Width = C_列幅.郵便番号;
            dgv顧客一覧.Columns[顧客一覧Cell.byt住所].Width = C_列幅.住所;
            dgv顧客一覧.Columns[顧客一覧Cell.bytTEL].Width = C_列幅.TEL;
            dgv顧客一覧.Columns[顧客一覧Cell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgv顧客一覧.Columns[顧客一覧Cell.bytメルマガ許諾].Width = C_列幅.メルマガ許諾;
            dgv顧客一覧.Columns[顧客一覧Cell.byt備考].Width = C_列幅.備考;
        }

        //検索で使用するSQLパラメータの取得
        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (txt顧客ID.Text == "")
                row.顧客ID = null;
            else
                row.顧客ID = txt顧客ID.Text;

            if (txt氏名.Text == "")
                row.氏名 = null;
            else
                row.氏名 = txt氏名.Text;

            if (txt氏名カナ.Text == "")
                row.氏名カナ = null;
            else
                row.氏名カナ = txt氏名カナ.Text;

            if (cmb性別.Text == "")
                row.性別 = null;
            else
                row.性別 = (int)cmb性別.SelectedValue;

            if (dtp生年月日.Checked == true)
                row.生年月日 = dtp生年月日.Value.Date;
            else
                row.生年月日 = null;

            if (txt郵便番号.Text == "")
                row.郵便番号 = null;
            else
                row.郵便番号 = txt郵便番号.Text;

            if (txt住所.Text == "")
                row.住所 = null;
            else
                row.住所 = txt住所.Text;

            if (txtTEL.Text == "")
                row.TEL = null;
            else
                row.TEL = txtTEL.Text;

            if (txtメールアドレス.Text == "")
                row.メールアドレス = null;
            else
                row.メールアドレス = txtメールアドレス.Text;

            if (cmbメルマガ許諾.Text == "")
                row.メルマガ許諾 = null;
            else
                row.メルマガ許諾 = (int)cmbメルマガ許諾.SelectedValue;

            return (row);
        }

        private bool IsValidate()
        {
            //// この処理はバインドのバグによって使えない。
            ////d16顧客.D16顧客検索Row[] dr = (d16顧客.D16顧客検索Row[])d16顧客.D16顧客検索.Select("選択 = True");
            //// 妥協ロジック
            //int i選択数 = 0;
            //for (int iRow = 0; iRow < dgv顧客一覧.RowCount; iRow++)
            //{
            //    if ((Boolean)dgv顧客一覧.Rows[iRow].Cells[顧客一覧Cell.byt選択].Value == true)
            //        i選択数++;
            //}
            ////チェックがされていなければエラー
            //if (i選択数 < 1)
            //{
            //    MessageBox.Show(string.Format(Properties.Resources.MSG_INF_008, "顧客")
            //        , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgv顧客一覧.Focus();
            //    return false;
            //}
            if (C01FormCommon.チェック選択数(dgv顧客一覧, 顧客一覧Cell.byt選択, this.Text
                , Properties.Resources.DGV列名_顧客) == false)
                return false;

            return true;
        }

        private void Set顧客検索結果()
        {
            D10顧客.D10顧客検索Row[] dr = (D10顧客.D10顧客検索Row[])d10顧客.D10顧客検索
                .Select(Properties.Resources.DGV列名_選択 + " = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                D10顧客.D10顧客検索Row dr顧客検索結果 = dt顧客検索結果.NewD10顧客検索Row();

                dr顧客検索結果.顧客No = dr[iRow].顧客No;
                dr顧客検索結果.顧客ID = dr[iRow].顧客ID;
                dr顧客検索結果.氏名 = dr[iRow].氏名;
                dr顧客検索結果.氏名カナ = dr[iRow].氏名カナ;
                dr顧客検索結果.性別 = dr[iRow].性別;
                dr顧客検索結果.生年月日 = dr[iRow].生年月日;
                dr顧客検索結果.郵便番号 = dr[iRow].郵便番号;
                dr顧客検索結果.住所 = dr[iRow].住所;
                dr顧客検索結果.TEL = dr[iRow].TEL;
                dr顧客検索結果.メールアドレス = dr[iRow].メールアドレス;

                dt顧客検索結果.AddD10顧客検索Row(dr顧客検索結果);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _116顧客検索_Load(object sender, EventArgs e)
        {
            try
            {

            }
            catch (Exception ex)
            {
                Set列幅();
                C04システム共通.ErrorLog("_116顧客検索", "_116顧客検索_Load", ex);
            }
        }

        private void _116顧客検索_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, false);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "_116顧客検索_Resize", ex);
            }
        }

        private void dgv顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv顧客一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv顧客一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv顧客一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "dgv顧客一覧_RowPostPaint", ex);
            }
        }


        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                txt顧客ID.Text = "";
                txt氏名.Text = "";
                txt氏名カナ.Text = "";
                cmb性別.Text = "";
                dtp生年月日.Value = DateTime.Today;
                dtp生年月日.Checked = false;
                txt郵便番号.Text = "";
                txt住所.Text = "";
                txtTEL.Text = "";
                txtメールアドレス.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                d10顧客検索bs.DataSource = null;
                検索条件 row = Get検索条件();

				C06DB共通.d10顧客検索ta.Fill(d10顧客.D10顧客検索
                                    , row.顧客ID
                                    , row.氏名
                                    , row.氏名カナ
                                    , row.性別
                                    , row.生年月日
                                    , row.郵便番号
                                    , row.住所
                                    , row.TEL
                                    , row.メールアドレス
                                    , row.メルマガ許諾);

                //選択済みの顧客を再選択
                if (mstr選択済み顧客No != "" && mstr選択済み顧客No != null)
                {
                    D10顧客.D10顧客検索Row[] dr = (D10顧客.D10顧客検索Row[])d10顧客.D10顧客検索
                        .Select(Properties.Resources.DGV列名_顧客No + " IN (" + mstr選択済み顧客No + ")");

                    for (int iRow = 0; iRow < dr.Length; iRow++)
                        dr[iRow].選択 = true;
                }

                //見つからない場合はメッセージ表示
                if (d10顧客.D10顧客検索.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btn検索_Click", ex);
            }
            finally
            {
                d10顧客検索bs.DataSource = d10顧客.D10顧客検索;
				lbl件数.Text = "検索結果：" + d10顧客.D10顧客検索.Count.ToString() + " 件";
				Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv顧客一覧.SelectedRows)
                    row.Cells[顧客一覧Cell.byt選択].Value = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btn選択行を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv顧客一覧.SelectedRows)
                    row.Cells[顧客一覧Cell.byt選択].Value = false;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d10顧客.D10顧客検索.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btn検索結果をクリア_Click", ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                if (false == IsValidate())
                    return;

                Cursor.Current = Cursors.WaitCursor;

                Set顧客検索結果();

                this.DialogResult = DialogResult.OK;
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btnOK_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_116顧客検索", "btnキャンセル_Click", ex);
            }
        }


        #endregion



    }
}
