﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

using System.Globalization;
using Microsoft.Maps.MapControl.WPF;
using Microsoft.Maps.MapControl.WPF.Design;

namespace MAP
{
	/// <summary>
	/// Window3.xaml の相互作用ロジック
	/// </summary>
	public partial class Window3 : Window
	{
		public Window3()
		{
			InitializeComponent();
			myMap.Focus();
		}

		private void MapWithPushpins_MouseDoubleClick(object sender, MouseButtonEventArgs e)
		{
			// Disables the default mouse double-click action.
			e.Handled = true;

			// Determin the location to place the pushpin at on the map.

			//Get the mouse click coordinates
			Point mousePosition = e.GetPosition(this);
			//Convert the mouse coordinates to a locatoin on the map
			Location pinLocation = myMap.ViewportPointToLocation(mousePosition);

			// The pushpin to add to the map.
			Pushpin pin = new Pushpin();
			pin.Location = pinLocation;

			// Adds the pushpin to the map.
			myMap.Children.Add(pin);


		}

		private void MapWithPushpins_TouchDown(object sender, TouchEventArgs e)
		{
			// Disables the default touch down behavior.
			e.Handled = true;

			// Determine the location to place the pushpin at on the map.

			//Get the touch down coordinates
			TouchPoint touchPosition = e.GetTouchPoint(this);
			//Convert the mouse coordinates to a location on the map
			Location pinLocation = myMap.ViewportPointToLocation(touchPosition.Position);

			// The pushpin to add to the map.
			Pushpin pin = new Pushpin();
			pin.Location = pinLocation;

			// Adds the pushpin to the map.
			myMap.Children.Add(pin);
		}
	}
}
