﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _505広告マスタ : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス

        private class 取込処理内部クラス : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    広告名 = 0,
			//    担当者名 = 1,
			//    TEL = 2,
			//    FAX = 3,
			//    メールアドレス = 4,
			//    URL = 5,
			//    備考 = 6
			//}
			private static class CSV取込列
			{
                public const byte byt広告名 = 0;
                public const byte byt担当者名 = 1;
                public const byte bytTEL = 2;
                public const byte bytFAX = 3;
                public const byte bytメールアドレス = 4;
                public const byte bytURL = 5;
                public const byte byt備考 = 6;
			}

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt備考 + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int rowIndex, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.byt広告名:
                        if (!IsValidate共通(value, true, C_最大文字数.広告名, C_正規表現.なし
                            , Properties.Resources.DGV列名_広告名))
                            return false;

                        break;

                    case CSV取込列.byt担当者名:
                        if (!IsValidate共通(value, true, C_最大文字数.氏名, C_正規表現.なし
                            , Properties.Resources.DGV列名_担当者名))
                            return false;

                        break;

                    case CSV取込列.bytTEL:
                        if (!IsValidate共通(value, true, C_最大文字数.TEL, C_正規表現.なし
                            , Properties.Resources.DGV列名_TEL))
                            return false;

                        break;

                    case CSV取込列.bytFAX:
                        if (!IsValidate共通(value, true, C_最大文字数.FAX, C_正規表現.なし
                            , Properties.Resources.DGV列名_FAX))
                            return false;

                        break;

                    case CSV取込列.bytメールアドレス:
                        if (!IsValidate共通(value, true, C_最大文字数.メールアドレス, C_正規表現.なし
                            , Properties.Resources.DGV列名_メールアドレス))
                            return false;

                        break;

                    case CSV取込列.bytURL:
                        if (!IsValidate共通(value, true, C_最大文字数.URL, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_URL))
                            return false;

                        break;

                    case CSV取込列.byt備考:
                        if (!IsValidate共通(value, true, C_最大文字数.備考, C_正規表現.なし
                            , Properties.Resources.DGV列名_備考))
                            return false;

                        break;

                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int rowIndex, List<string> values, DataTable dt)
            {
                D16広告.D16広告DataTable dt広告 = (D16広告.D16広告DataTable)dt;
                D16広告.D16広告Row row = dt広告.NewD16広告Row();

                row.新規 = true;
                row.広告名 = values[CSV取込列.byt広告名];
                row.担当者名 = values[CSV取込列.byt担当者名];
                row.TEL = values[CSV取込列.bytTEL];
                row.FAX = values[CSV取込列.bytFAX];
                row.メールアドレス = values[CSV取込列.bytメールアドレス];
                row.URL = values[CSV取込列.bytURL];
                row.備考 = values[CSV取込列.byt備考];

                dt広告.AddD16広告Row(row);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

		//private enum enm広告一覧Cell : int
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    広告No = 3,
		//    広告名 = 4,
		//    担当者名 = 5,
		//    TEL = 6,
		//    FAX = 7,
		//    メールアドレス = 8,
		//    URL = 9,
		//    備考 = 10
		//}
		private static class 広告一覧Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte byt広告No = 3;
            public const byte byt広告名 = 4;
            public const byte byt担当者名 = 5;
            public const byte bytTEL = 6;
            public const byte bytFAX = 7;
            public const byte bytメールアドレス = 8;
            public const byte bytURL = 9;
			public const byte byt備考 = 10;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _505広告マスタ()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static

		//最終行でかつ全項目未入力となっているかを返す
		private static bool 最終行or全項目未入力(DataGridView dgv, int rowIndex)
		{
			if ((dgv.RowCount - 1) != rowIndex)
				return false;

			if ((dgv.Rows[rowIndex].Cells[広告一覧Cell.byt広告No].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.byt広告名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.byt担当者名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.bytTEL].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.bytFAX].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.bytメールアドレス].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.bytURL].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[広告一覧Cell.byt備考].FormattedValue.ToString() == string.Empty))
				return true;

			return false;
		}

		private bool IsValidateDGV広告一覧(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力(dgv, iRow))
				return ret;

			for (int iCol = 0; iCol < dgv広告一覧.ColumnCount; iCol++)
			{
				string value = dgv広告一覧.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case 広告一覧Cell.byt広告名:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv広告一覧, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}

		private static bool IsValidate未入力行(DataGridViewRow row)
		{
			if ((row.Cells[広告一覧Cell.byt広告No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.byt広告名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.byt担当者名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.bytTEL].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.bytFAX].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.bytメールアドレス].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.bytURL].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[広告一覧Cell.byt備考].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}


		private static bool IsValidate新規変更削除チェック状態(DataGridView dgv, string strFormTitle)
		{
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				string strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					広告一覧Cell.byt新規, 広告一覧Cell.byt変更, 広告一覧Cell.byt削除,
					広告一覧Cell.byt広告No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅()
        {
            dgv広告一覧.Columns[広告一覧Cell.byt新規].Visible = false;
            dgv広告一覧.Columns[広告一覧Cell.byt変更].Visible = false;
            dgv広告一覧.Columns[広告一覧Cell.byt削除].Width = C_列幅.削除;
            dgv広告一覧.Columns[広告一覧Cell.byt広告No].Visible = false;
            dgv広告一覧.Columns[広告一覧Cell.byt広告名].Width = C_列幅.広告名;
            dgv広告一覧.Columns[広告一覧Cell.byt担当者名].Width = C_列幅.氏名;
            dgv広告一覧.Columns[広告一覧Cell.bytTEL].Width = C_列幅.TEL;
            dgv広告一覧.Columns[広告一覧Cell.bytFAX].Width = C_列幅.FAX;
            dgv広告一覧.Columns[広告一覧Cell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgv広告一覧.Columns[広告一覧Cell.bytURL].Width = C_列幅.URL;
            dgv広告一覧.Columns[広告一覧Cell.byt備考].Width = C_列幅.備考;
        }

        private bool IsValidate()
        {
            //必須入力欄
			if ((dgv広告一覧.RowCount == 1) && (最終行or全項目未入力(dgv広告一覧, 0)))
            {
                MessageBox.Show(Properties.Resources.MSG_W_販売履歴が入力されていません, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Warning);
                dgv広告一覧.Focus();
                return false;
            }

            if (IsValidate新規変更削除チェック状態(dgv広告一覧, this.Text) == false)
                return false;

            //未入力
            bool b新規変更削除にチェック有り = false;
            for (int iRow = 0; iRow < dgv広告一覧.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv広告一覧, iRow) == true)
                    continue;

                if ((Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt新規].Value == false &&
                    (Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt変更].Value == false &&
                    (Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt削除].Value == false)
                    continue;

                b新規変更削除にチェック有り = true;
                break;
            }

            if (b新規変更削除にチェック有り == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_編集された行がありません, this.Text
					, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                dgv広告一覧.Focus();
                return false;
            }

            //編集されたセルを全てチェックする
            bool isValid = true;
            for (int iRow = 0; iRow < dgv広告一覧.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv広告一覧, iRow) == true)
                    continue;

                if ((Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt新規].Value == false &&
                    (Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt変更].Value == false &&
                    (Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt削除].Value == false)
                    continue;

				if (!IsValidateDGV広告一覧(dgv広告一覧, iRow))
                    isValid = false;
            }

            if (!isValid)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aの入力内容に誤りがある為_登録を完了できません, Properties.Resources.MSG_TTL_広告一覧)
                    , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                dgv広告一覧.Focus();
                return false;
            }

            return true;
        }

        private void Insert広告一覧()
        {
            D16広告.D16広告Row[] dr = (D16広告.D16広告Row[])d16広告._D16広告
                .Select(Properties.Resources.DGV列名_新規 + " = true");

            string str広告名リスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                d16広告ta.Insert(dr[iRow].広告名, dr[iRow].担当者名, dr[iRow].TEL, dr[iRow].FAX, 
                    dr[iRow].メールアドレス, dr[iRow].URL, dr[iRow].備考, C02業務共通処理.miログインスタッフNo);

                str広告名リスト += dr[iRow].広告名 + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_017
                    + "=" + str広告名リスト.Substring(0, str広告名リスト.Length - 2));
        }

        private void Update広告一覧()
        {
            D16広告.D16広告Row[] dr = (D16広告.D16広告Row[])d16広告._D16広告
                .Select(Properties.Resources.DGV列名_変更 + " = true");

            string str広告名リスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                d16広告ta.Update(dr[iRow].広告名, dr[iRow].担当者名, dr[iRow].TEL, dr[iRow].FAX, dr[iRow].メールアドレス, 
                    dr[iRow].URL, dr[iRow].備考, C02業務共通処理.miログインスタッフNo, dr[iRow].広告No);

                str広告名リスト += dr[iRow].広告名 + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_018
                    + "=" + str広告名リスト.Substring(0, str広告名リスト.Length - 2));
        }

        private void Delete広告一覧()
        {
            string str広告名リスト = "";
            int i削除行数 = 0;
            for (int iRow = 0; iRow < dgv広告一覧.RowCount; iRow++)
            {
                if (dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt削除].Value == false)
                    continue;

                if (dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt広告No].Value.ToString() == "")
                    continue;

                d16広告ta.Delete(int.Parse(dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt広告No].Value.ToString()));

                str広告名リスト += dgv広告一覧.Rows[iRow].Cells[広告一覧Cell.byt広告名].Value.ToString() + ", ";

                i削除行数++;
            }

            if (i削除行数 > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_019
                    + "=" + str広告名リスト.Substring(0, str広告名リスト.Length - 2));
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _114広告マスタ_Load(object sender, EventArgs e)
        {
            try
            {
                d16広告ta.Fill(d16広告._D16広告);
				lbl件数.Text = "検索結果：" + d16広告._D16広告.Count.ToString() + " 件";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "_114広告マスタ_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void _114広告マスタ_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "_114広告マスタ_Resize", ex);
            }
        }

        private void dgv広告一覧_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 広告一覧Cell.byt広告名:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 広告一覧Cell.byt担当者名:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 広告一覧Cell.bytTEL:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 広告一覧Cell.bytFAX:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 広告一覧Cell.bytメールアドレス:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 広告一覧Cell.bytURL:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 広告一覧Cell.byt備考:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv広告一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv広告一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "dgv広告一覧_CellValidating", ex);
            }
        }

        private void dgv広告一覧_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 広告一覧Cell.byt広告No,
                    広告一覧Cell.byt新規, 広告一覧Cell.byt変更, 広告一覧Cell.byt削除,
                    ref dgv広告一覧);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "dgv広告一覧_CellValueChanged", ex);
            }
        }

        private void dgv広告一覧_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "dgv広告一覧_DataError", ex);
            }
        }

        private void dgv広告一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv広告一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv広告一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv広告一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "dgv広告一覧_RowPostPaint", ex);
            }
        }

        private void dgv広告一覧_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv広告一覧.RowCount)
                {
					IsValidateDGV広告一覧(dgv広告一覧, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "dgv広告一覧_RowValidating", ex);
            }
        }

        private void btnCSVファイル読込_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                d16広告bs.DataSource = null;

                取込処理内部クラス 取込処理 = new 取込処理内部クラス();
                D16広告.D16広告DataTable dt = new D16広告.D16広告DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                d16広告._D16広告.Merge(dt);
            }
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_114広告マスタ", "btnCSVファイル読込_Click", ex);
            }
            finally
            {
                d16広告bs.DataSource = d16広告._D16広告;

                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }

        private void btn選択行の削除を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv広告一覧.SelectedRows)
                {
                    if (IsValidate未入力行(row))
                        continue;

                    row.Cells[広告一覧Cell.byt新規].Value = false;
                    row.Cells[広告一覧Cell.byt変更].Value = false;
                    row.Cells[広告一覧Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv広告一覧.SelectedRows)
                {
                    row.Cells[広告一覧Cell.byt新規].Value = false;
                    row.Cells[広告一覧Cell.byt変更].Value = false;
                    row.Cells[広告一覧Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行をCSVファイルに出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv広告一覧.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV ファイル(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				//C06CSV.CreateCSVファイル(dgv広告一覧, sfd.FileName, true, 4, true, "");
				if (C06CSV.CreateCSVファイル(dgv広告一覧, sfd.FileName, true, 4, true, "") == false)
					return;

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "btn選択行をCSVファイルに出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                if (false == IsValidate())
                {
                    Cursor.Current = Cursors.Arrow;
                    return;
                }

                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;

                Insert広告一覧();
                Update広告一覧();
                Delete広告一覧();

                d16広告ta.Fill(d16広告._D16広告);

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_114広告マスタ", "btnキャンセル_Click", ex);
            }
        }


        #endregion


    }
}
