﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _504スタッフ権限マスタ : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        byte b追加変更フラグ = 2;   //1：追加　2：変更

		private static class 閲覧編集可能画面一覧Cell
		{
            public const byte byt可 = 0;
            public const byte byt画面No = 1;
			public const byte byt画面名 = 2;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _504スタッフ権限マスタ()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv閲覧編集可能画面一覧.Columns[閲覧編集可能画面一覧Cell.byt可].Width = C_列幅.新規;
            dgv閲覧編集可能画面一覧.Columns[閲覧編集可能画面一覧Cell.byt画面No].Visible = false;
            dgv閲覧編集可能画面一覧.Columns[閲覧編集可能画面一覧Cell.byt画面名].Width = C_列幅.画面名;
        }

        private void Set画面一覧()
        {
            d12権限画面一覧ta.Fill(d12スタッフ.D12権限画面一覧, int.Parse(cmb権限.SelectedValue.ToString()));
        }

        private bool 権限名新規登録(string str権限名, ref int i権限No)
        {

            if (d12権限画面一覧ta.Scalar同一権限名(C_属性区分.権限, str権限名) > 0)
                return false;
            else
                d01属性ta.Insert(C_属性区分.権限, str権限名, C02業務共通処理.miログインスタッフNo,
                    C02業務共通処理.miログインスタッフNo);

            i権限No = (int)d01属性ta.Scalar属性No(C_属性区分.権限, str権限名);

            return true;
        }

        #endregion



        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _112スタッフ権限マスタ_Load(object sender, EventArgs e)
        {
            try
            {
                txt権限名.Visible = false;
                lbl必須.Visible = false;

                this.d01権限ta.Fill(this.d01業務共通.D01権限);
                cmb権限.SelectedIndex = 0;

                Set画面一覧();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "_112スタッフ権限マスタ_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void dgv閲覧編集可能画面一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv閲覧編集可能画面一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv閲覧編集可能画面一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv閲覧編集可能画面一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "dgv閲覧編集可能画面一覧_RowPostPaint", ex);
            }
        }

        private void cmb権限_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                Set画面一覧();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "cmb権限_SelectedIndexChanged", ex);
            }
        }

        private void btn追加_Click(object sender, EventArgs e)
        {
            try
            {
                cmb権限.Visible = false;
                btn追加.Visible = false;

                txt権限名.Visible = true;
                txt権限名.Focus();
                lbl必須.Visible = true;

                foreach (DataGridViewRow row in dgv閲覧編集可能画面一覧.Rows)
                    row.Cells[閲覧編集可能画面一覧Cell.byt可].Value = false;

                b追加変更フラグ = 1;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "btn追加_Click", ex);
            }
        }

        private void btn選択行を全てにチェックを付ける_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (DataGridViewRow row in dgv閲覧編集可能画面一覧.SelectedRows)
                    row.Cells[閲覧編集可能画面一覧Cell.byt可].Value = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "btn選択行を全てにチェックを付ける_Click", ex);
            }
        }

        private void btn選択行を全てのチェックを外す_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (DataGridViewRow row in dgv閲覧編集可能画面一覧.SelectedRows)
                    row.Cells[閲覧編集可能画面一覧Cell.byt可].Value = false;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "btn選択行を全てのチェックを外す_Click", ex);
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;

                D12スタッフ.D12権限画面一覧Row[] dr = (D12スタッフ.D12権限画面一覧Row[])d12スタッフ.D12権限画面一覧.Select();

                if (b追加変更フラグ == 1)
                {
                    int i権限No = 0;
                    if (権限名新規登録(txt権限名.Text, ref i権限No) == false)
                    { 
                        MessageBox.Show(Properties.Resources.MSG_W_入力された権限名は_既に登録されています, this.Text, MessageBoxButtons.OK,
                            MessageBoxIcon.Warning);
                        return;
                    }

                    for (int iRow = 0; iRow < dr.Length; iRow++)
                        d12権限画面一覧ta.Insertオープン可能画面(i権限No, dr[iRow].画面No, dr[iRow].可不可, 
                            C02業務共通処理.miログインスタッフNo);

                    C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_026
                        + "=" + txt権限名.SelectedText);
                }
                else if (b追加変更フラグ == 2)
                { 
                    int i権限No = int.Parse(cmb権限.SelectedValue.ToString());
                    for (int iRow = 0; iRow < dr.Length; iRow++)
                        d12権限画面一覧ta.Updateオープン可能画面(dr[iRow].可不可, i権限No, dr[iRow].画面No, 
                            C02業務共通処理.miログインスタッフNo);

                    C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_027
                        + "=" + cmb権限.SelectedText);
                }

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_112スタッフ権限マスタ", "btnキャンセル_Click", ex);
            }
        }

        #endregion




    }
}
