﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CSV変換ツール
{
    public partial class _101CSV変換ツール : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス

        private class 取込処理内部クラス : C03CSV取込処理基底
        {
            // 楽天市場の通常購入CSV
            private enum enmCSV取込列_楽天通常
            {
                注文日 = 2,
                注文時間 = 3,
                商品名 = 4,
                商品番号 = 5,
                個数 = 6,
                単価 = 7,
                注文者名字 = 9,
                注文者名前 = 10,
                注文者名字フリガナ = 11,
                注文者名前フリガナ = 12,
                メールアドレス = 13,
                注文者郵便番号1 = 14,
                注文者郵便番号2 = 15,
                注文者住所都道府県 = 16,
                注文者住所都市区 = 17,
                注文者住所町以降 = 18,
                注文者電話番号1 = 19,
                注文者電話番号2 = 20,
                注文者電話番号3 = 21,
                注文者性別 = 22
            }

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return 64;  //楽天の項目から求めた
            }

            protected override bool 基底CSV取込クラスからの検証(int rowIndex, int colIndex, string value)
            {
                DateTime dt;
                switch (colIndex)
                {
                    case (int)enmCSV取込列_楽天通常.注文日:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.販売日時, enm正規表現.半角英数, "注文日", 0))
                            return false;

                        // 日付型チェック
                        if (DateTime.TryParse(value, out dt) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_INF_088, "注文日");
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt.Year < (int)enm最小値.年 || (int)enm最大値.年 < dt.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_INF_089, "注文日", (int)enm最小値.年, (int)enm最大値.年);
                            return false;
                        }

                        break;

                    case (int)enmCSV取込列_楽天通常.注文時間:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.販売日時, enm正規表現.半角英数, "注文時間", 0))
                            return false;

                        // 日付型チェック
                        if (DateTime.TryParse(value, out dt) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_INF_103, "注文時間");
                            return false;
                        }

                        break;

                    case (int)enmCSV取込列_楽天通常.商品番号:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.商品ID, enm正規表現.半角英数, "商品番号", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.商品名:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.商品名, enm正規表現.なし, "商品名", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.単価: 
                        //必須入力、桁数、書式検証
                        value = value.Replace(",", string.Empty);
                        if (!IsValidate共通(value, true, (int)enm最大文字数.商品単価, enm正規表現.半角数字, "単価", (long)enm最大値.商品単価))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.個数:
                        //必須入力、桁数、書式検証
                        value = value.Replace(",", string.Empty);
                        if (!IsValidate共通(value, true, (int)enm最大文字数.販売個数, enm正規表現.半角数字, "個数", (long)enm最大値.販売個数))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者名字:  // 氏名（姓）
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.氏名, enm正規表現.なし, "注文者名字", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者名前:  // 氏名（名）
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.氏名, enm正規表現.なし, "注文者名前", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者名字フリガナ:  // 氏名フリガナ（姓）
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, (int)enm最大文字数.氏名カナ, enm正規表現.全角カタカナ, "注文者名字フリガナ", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者名前フリガナ:  // 氏名フリガナ（名）
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, (int)enm最大文字数.氏名カナ, enm正規表現.全角カタカナ, "注文者名前フリガナ", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.メールアドレス:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, (int)enm最大文字数.メールアドレス, enm正規表現.メールアドレス, "メールアドレス", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者郵便番号1:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, (int)enm最大文字数.郵便番号, enm正規表現.半角英数, "郵便番号", 0))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者郵便番号2:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, (int)enm最大文字数.郵便番号, enm正規表現.半角英数, "郵便番号", 0))
                            return false;

                        break;

                    //case (int)enmCSV取込列_楽天通常.注文者住所都道府県:

                    //    break;

                    //case (int)enmCSV取込列_楽天通常.注文者住所都市区:

                    //    break;

                    //case (int)enmCSV取込列_楽天通常.注文者住所町以降:

                    //    break;

                    case (int)enmCSV取込列_楽天通常.注文者電話番号1:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.TEL各個, enm正規表現.半角数字, "注文者電話番号1", (long)enm最大値.TEL各個))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者電話番号2:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.TEL各個, enm正規表現.半角数字, "注文者電話番号2", (long)enm最大値.TEL各個))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者電話番号3:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, (int)enm最大文字数.TEL各個, enm正規表現.半角数字, "注文者電話番号3", (long)enm最大値.TEL各個))
                            return false;

                        break;

                    case (int)enmCSV取込列_楽天通常.注文者性別:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, false, (int)enm最大文字数.性別, enm正規表現.なし, "注文者性別", 0))
                            return false;

                        break;


                }

                return true;
            }


            protected override bool 基底CSV取込クラスからのデータ変換(int rowIndex, List<string> values, ref D10顧客.D10顧客販売履歴DataTable dt, ref string strErrDetail)
            {
                D10顧客.D10顧客販売履歴Row row = dt.NewD10顧客販売履歴Row();

                row.販売日時 = DateTime.Parse(values[(int)enmCSV取込列_楽天通常.注文日] + " " + values[(int)enmCSV取込列_楽天通常.注文時間]);
                row.商品ID = values[(int)enmCSV取込列_楽天通常.商品番号];
                row.商品名 = values[(int)enmCSV取込列_楽天通常.商品名];
                string strTmp = values[(int)enmCSV取込列_楽天通常.単価].Replace(",", "");
                row.商品単価 = long.Parse(strTmp);
                row.販売個数 = long.Parse(values[(int)enmCSV取込列_楽天通常.個数]);
                row.顧客ID = "";
                row.氏名 = values[(int)enmCSV取込列_楽天通常.注文者名字] + "　" + values[(int)enmCSV取込列_楽天通常.注文者名前];
                row.氏名カナ = values[(int)enmCSV取込列_楽天通常.注文者名字フリガナ] + "　" + values[(int)enmCSV取込列_楽天通常.注文者名前フリガナ];
                row.性別 = Program.業務共通処理.Get性別(values[(int)enmCSV取込列_楽天通常.注文者性別]);
                //row.生年月日 = "";
                row.郵便番号 = values[(int)enmCSV取込列_楽天通常.注文者郵便番号1] + "-" + values[(int)enmCSV取込列_楽天通常.注文者郵便番号2];
                row.住所 = values[(int)enmCSV取込列_楽天通常.注文者住所都道府県] + values[(int)enmCSV取込列_楽天通常.注文者住所都市区] + " " + values[(int)enmCSV取込列_楽天通常.注文者住所町以降];
                row.TEL = values[(int)enmCSV取込列_楽天通常.注文者電話番号1] + "-" + values[(int)enmCSV取込列_楽天通常.注文者電話番号2] + " " + values[(int)enmCSV取込列_楽天通常.注文者電話番号3];
                row.メールアドレス = values[(int)enmCSV取込列_楽天通常.メールアドレス];
                row.備考 = "";

                
                ////////////////////////////////////////////////////////////////////////
                // 文字数チェック
                ////////////////////////////////////////////////////////////////////////
                if (!IsValidate共通(row.氏名, false, (int)enm最大文字数.氏名, enm正規表現.なし, "注文者名字と注文者名前", 0))
                {
                    mLastErrorMessage = string.Format(Properties.Resources.MSG_INF_049, rowIndex + 1, ((int)enmCSV取込列_楽天通常.注文者名字 + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者名前 + 1).ToString());
                    return false;
                }
                if (!IsValidate共通(row.氏名カナ, false, (int)enm最大文字数.氏名カナ, enm正規表現.なし, "注文者名字フリガナと注文者名字フリガナ", 0))
                {
                    mLastErrorMessage = string.Format(Properties.Resources.MSG_INF_049, rowIndex + 1, ((int)enmCSV取込列_楽天通常.注文者名字フリガナ + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者名前フリガナ + 1).ToString());
                    return false;
                }
                if (!IsValidate共通(row.郵便番号, false, (int)enm最大文字数.郵便番号, enm正規表現.半角英数, "注文者郵便番号1と注文者郵便番号2", 0))
                {
                    mLastErrorMessage = string.Format(Properties.Resources.MSG_INF_049, rowIndex + 1, ((int)enmCSV取込列_楽天通常.注文者郵便番号1 + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者郵便番号2 + 1).ToString());
                    return false;
                }
                if (!IsValidate共通(row.住所, false, (int)enm最大文字数.住所, enm正規表現.なし, "注文者住所都道府県と注文者住所都市区と注文者住所町以降", 0))
                {
                    mLastErrorMessage = string.Format(Properties.Resources.MSG_INF_049, rowIndex + 1, ((int)enmCSV取込列_楽天通常.注文者住所都道府県 + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者住所都市区 + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者住所町以降 + 1).ToString());
                    return false;
                }
                if (!IsValidate共通(row.TEL, false, (int)enm最大文字数.TEL, enm正規表現.半角英数, "注文者電話番号1と注文者電話番号2と注文者電話番号3", 0))
                {
                    mLastErrorMessage = string.Format(Properties.Resources.MSG_INF_049, rowIndex + 1, ((int)enmCSV取込列_楽天通常.注文者電話番号1 + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者電話番号2 + 1).ToString() + "・" + ((int)enmCSV取込列_楽天通常.注文者電話番号3 + 1).ToString());
                    return false;
                }

                dt.AddD10顧客販売履歴Row(row);
                return true;
            }
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数


        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド
                
        public _101CSV変換ツール()
        {
            InitializeComponent();
        }

        public int Get商品No(string str商品ID, string str商品名, long int商品単価)
        {
            // 商品IDが、M02商品に登録されているかチェック
            if ((int)d03商品ta.Scalar同一商品ID(str商品ID) == 0)
            {
                //登録されていなかったら、新商品として、M02商品に登録。
                d03商品ta.InsertQuery(str商品ID, str商品名, int商品単価);
            }

            D03販売履歴.D03商品DataTable dt商品 = new D03販売履歴.D03商品DataTable();
            d03商品ta.FillBy商品No取得(dt商品, str商品ID);
            return dt商品[0].商品No;
        }

        public int Get顧客No(string str顧客ID)
        {
            // 顧客IDが、M03顧客に登録されているかチェック
            // 登録されていない場合、顧客一覧画面の登録処理で保管。ここでは顧客の新規登録は行わず、M03顧客の更新処理で、H01販売履歴の顧客Noを更新する
            D10顧客.D10顧客DataTable dt顧客 = new D10顧客.D10顧客DataTable();
            d10顧客ta.FillBy顧客No取得(dt顧客, str顧客ID);

            if (dt顧客.Count > 0)
                return dt顧客[0].顧客No;
            else
            {
                //return 0;

                d10顧客2ta.InsertQuery(str顧客ID, "", "",
                                      1, "", "",
                                      "", "", "",
                                      DateTime.MinValue);

                d10顧客ta.FillBy顧客No取得(dt顧客, str顧客ID);
                return dt顧客[0].顧客No;
            }
        }


        public void Insert顧客リスト(ref D10顧客.D10顧客販売履歴DataTable dt)
        {
            pgs取込状況.Minimum = 1;
            pgs取込状況.Value = 1;
            pgs取込状況.Step = 1;
            pgs取込状況.Maximum = dt.Count;

            for (int iRow = 0; iRow < dt.Count; iRow++)
            {
                // 顧客を検索
                D10顧客.D10顧客DataTable dt顧客 = new D10顧客.D10顧客DataTable();
                d10顧客ta.FillBy近似顧客(dt顧客, dt[iRow].氏名, dt[iRow].TEL);

                if (dt顧客.Count == 0)
                {
                     //未登録であれば顧客を新規登録
                    d10顧客2ta.InsertQuery(dt[iRow].顧客ID, dt[iRow].氏名, dt[iRow].氏名カナ,
                                              dt[iRow].性別, dt[iRow].郵便番号,
                                              dt[iRow].住所, dt[iRow].TEL, dt[iRow].メールアドレス,
                                              dt[iRow].備考, dt[iRow].生年月日);

                    // 顧客を再度検索
                    d10顧客ta.FillBy近似顧客(dt顧客, dt[iRow].氏名, dt[iRow].TEL);

                    // 顧客Noを顧客IDとしてセット
                    d10顧客ta.Update顧客ID(dt顧客[0].顧客No.ToString());
                }

                // 顧客Noを顧客IDとしてセット
                dt[iRow].顧客ID = dt顧客[0].顧客No.ToString();
                dt[iRow].顧客No = dt顧客[0].顧客No;

                pgs取込状況.PerformStep();
            }
        }

        public void Insert販売履歴(D10顧客.D10顧客販売履歴DataTable dt)
        {
            for (int iRow = 0; iRow < dt.Count; iRow++)
            {
                int int商品No = Get商品No(dt[iRow].商品ID, dt[iRow].商品名, dt[iRow].商品単価);

                // H01販売履歴に登録
                d03販売履歴ta.InsertQuery(dt[iRow].販売日時, dt[iRow].商品ID, dt[iRow].商品名, dt[iRow].商品単価,
                                          dt[iRow].販売個数, dt[iRow].商品単価 * dt[iRow].販売個数,
                                          dt[iRow].顧客ID, int商品No, dt[iRow].顧客No);
            }
        }

        // 最新日時を持つ商品名・単価で、M02商品を更新
        public void M02商品を更新()
        {
            D03販売履歴.D03商品DataTable dt商品 = new D03販売履歴.D03商品DataTable();
            d03商品ta.Fill(dt商品);

            D03販売履歴.D03販売履歴DataTable dt販売履歴 = new D03販売履歴.D03販売履歴DataTable();
            for (int iRow = 0; iRow < dt商品.Count; iRow++)
            {
                d03販売履歴ta.FillBy最新商品情報(dt販売履歴, dt商品[iRow].商品No);
                d03商品ta.UpdateQuery(dt販売履歴[0].商品名, dt販売履歴[0].商品単価, dt商品[iRow].商品No);
            }

        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private bool IsExistシステムファイル()
        {
            if (File.Exists(System.Environment.CurrentDirectory + "\\CSV取込ツール.exe.config") == false)
            {
#if RELEASE
#else
                MessageBox.Show(this, System.Environment.CurrentDirectory + "\\CSV取込ツール.exe.config",
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
#endif
                return false;
            }

            return true;
        }

        //private void 試用期限チェック()
        //{
        //    // シリアル未確認であれば、試用期限をチェック
        //    d01属性ta.FillBy検索(d01業務共通.D01属性, 16, 7);
        //    if (d01業務共通.D01属性[0].値 == "1")
        //    {
        //        // 試用期限を過ぎていたら終了
        //        D01業務共通.D01属性DataTable dt = new D01業務共通.D01属性DataTable();
        //        d01属性ta.FillBy検索(dt, 14, 5);
        //        if (dt[0].値 == "")
        //        {
        //            this.Close();
        //        }
        //        else
        //        {
        //            TimeSpan ts初期起動日と今日との差 = (TimeSpan)(DateTime.Today - DateTime.Parse(dt[0].値));
        //            if (ts初期起動日と今日との差.TotalDays > 30)
        //            {
        //                MessageBox.Show(this, Properties.Resources.MSG_INF_004, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

        //                this.Close();
        //            }
        //        }
        //    }
        //}
        private void 試用期限チェック()
        {
            // シリアル未確認であれば、試用期限をチェック
            if (Properties.Settings.Default.シリアル承認 == 1)  // 1：未承認　2：承認済み
            {
                // 試用期限を過ぎていたら終了
                if (Properties.Settings.Default.初期起動日 == "")
                {
                    Properties.Settings.Default.初期起動日 = DateTime.Today.ToString();
                    Properties.Settings.Default.Save();
                }
                else
                {
                    TimeSpan ts初期起動日と今日との差 = (TimeSpan)(DateTime.Today - DateTime.Parse(Properties.Settings.Default.初期起動日));
                    if (ts初期起動日と今日との差.TotalDays > 30)
                    {
                        MessageBox.Show("試用期間を過ぎた為、起動する事はできません。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                        this.Close();
                    }
                }
            }
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _101CSV変換ツール_Load(object sender, EventArgs e)
        {
            try
            {
                if (Program.業務共通処理.Chk多重起動() == false)
                {
                    this.Close();
                    return;
                }

#if RELEASE
                Properties.Settings.Default.KB = Properties.Settings.Default.R_KB;
                Properties.Settings.Default.MASTER = Properties.Settings.Default.R_MASTER;
                Properties.Settings.Default.SQLSERVER_SERVICE_NAME = Properties.Settings.Default.R_SQLSERVER_SERVICE_NAME;
#endif

                string strTmp = "";
                if (Program.業務共通処理.ChkSQLServer(ref strTmp) == false)
                {
                    MessageBox.Show(this, Properties.Resources.MSG_INF_012, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);

                    this.Close();
                    return;
                }

                if (IsExistシステムファイル() == false)
                {
                    MessageBox.Show(this, Properties.Resources.MSG_INF_083, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);

                    this.Close();
                    return;
                }


                if (Program.業務共通処理.IsExistDB() == false)
                {
                    MessageBox.Show(this, Properties.Resources.MSG_INF_090, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);

                    this.Close();
                    return;
                }

                if (Program.業務共通処理.IsExistSP() == false)
                {
                    MessageBox.Show(this, Properties.Resources.MSG_INF_090, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);

                    this.Close();
                    return;
                }

                //if (Properties.Settings.Default.シリアル承認 == 1)
                //{
                //    _105シリアルキー入力 _105シリアルキー入力 = null;
                //    _105シリアルキー入力 = new _105シリアルキー入力();
                //    _105シリアルキー入力.ShowDialog();
                //}

                //// シリアル未確認であれば、試用期限をチェック
                //試用期限チェック();


            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_101CSV変換ツール", "_101CSV変換ツール_Load", ex);
            }
        }

        private void btn参照_変換元_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog fd = new OpenFileDialog();
                fd.Filter = "CSV ファイル(*.csv)|*.csv";
                if (fd.ShowDialog(this) == DialogResult.Cancel)
                    return;

                txt変換元.Text = fd.FileName;


            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_101CSV変換ツール", "btn参照_変換元_Click", ex);
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                // エラーチェック
                if (txt変換元.Text == "")
                {
                    MessageBox.Show("CSVファイルが指定されていません", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (DialogResult.Yes != MessageBox.Show(this, Properties.Resources.MSG_INF_005
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;
                btnOK.Enabled = false;
                btnキャンセル.Enabled = false;
                pgs取込状況.Minimum = 1;
                pgs取込状況.Value = 1;

                lbl取込中の処理内容.Text = "CSVファイルの内容にエラーが無いかチェック中　（1/3）";
                lbl取込中の処理内容.Refresh();

                取込処理内部クラス 取込処理 = new 取込処理内部クラス();
                D10顧客.D10顧客販売履歴DataTable dt = new D10顧客.D10顧客販売履歴DataTable();

                // CSV読込とフォーマット変換
                if (!取込処理.CSV変換(txt変換元.Text, ref dt))
                {
                    string errmsg = 取込処理.LastErrorMessage + "\n\n【詳細】\n" + 取込処理.ErrorDetail;
                    MessageBox.Show(this, errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                //最大登録件数チェック
                int intCnt = (int)d03販売履歴ta.Scalar販売履歴Cnt() + dt.Count;
                if (intCnt > (int)enm最大値.登録件数)
                {
                    string msg = string.Format(Properties.Resources.MSG_INF_101, (int)enm最大値.登録件数);
                    MessageBox.Show(this, msg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                lbl取込中の処理内容.Text = "顧客一覧を取込中　（2/3）";
                lbl取込中の処理内容.Refresh();

                // 顧客一覧テーブルへ登録
                Insert顧客リスト(ref dt);


                lbl取込中の処理内容.Text = "販売履歴を取込中　（3/3）";
                lbl取込中の処理内容.Refresh();

                Insert販売履歴(dt);

                M02商品を更新();

                Program.業務共通処理.未登録顧客の顧客Noを0にする();


                lbl取込中の処理内容.Text = "完了";
                
                MessageBox.Show(this, Properties.Resources.MSG_INF_007, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_101CSV変換ツール", "btnOK_Click", ex);
            }
            finally
            {
                btnOK.Enabled = true;
                btnキャンセル.Enabled = true;
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                Program.業務共通処理.ErrorLog("_101CSV変換ツール", "btnキャンセル_Click", ex);
            }
        }

        #endregion



    }
}
