﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _603商品検索 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public string mstr選択済み商品No;
        public string mstr購入済み商品ID;

        public D06商品一覧.D06商品DataTable dt商品検索結果 = new D06商品一覧.D06商品DataTable();

		//private enum enm商品一覧Cell : int
		//{
		//    選択 = 0,
		//    商品No = 1,
		//    商品ID = 2,
		//    商品名 = 3,
		//    商品単価 = 4
		//}
		private static class 商品一覧Cell
		{
            public const byte byt選択 = 0;
            public const byte byt商品No = 1;
            public const byte byt商品ID = 2;
            public const byte byt商品名 = 3;
			public const byte byt商品単価 = 4;
		}

        private class 検索条件
        {
            public string 商品ID { get; set; }
            public string 商品名 { get; set; }
            public Nullable<long> 商品単価 { get; set; }
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _603商品検索()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv商品一覧.Columns[商品一覧Cell.byt選択].Width = C_列幅.新規;
            dgv商品一覧.Columns[商品一覧Cell.byt商品No].Visible = false;
            dgv商品一覧.Columns[商品一覧Cell.byt商品ID].Width = C_列幅.商品ID;
            dgv商品一覧.Columns[商品一覧Cell.byt商品名].Width = C_列幅.商品名;
            dgv商品一覧.Columns[商品一覧Cell.byt商品単価].Width = C_列幅.商品単価;
        }

        //検索で使用するSQLパラメータの取得
        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (txt商品ID.Text == "")
                row.商品ID = null;
            else
                row.商品ID = txt商品ID.Text;

            if (txt商品名.Text == "")
                row.商品名 = null;
            else
                row.商品名 = txt商品名.Text;

            if (txt商品単価.Text == "")
                row.商品単価 = null;
            else
                row.商品単価 =int.Parse( txt商品単価.Text);

            return (row);
        }

        private bool IsValidate()
        {
            //// この処理はバインドのバグによって使えない。
            ////D06商品一覧.D06商品Row[] dr = (D06商品一覧.D06商品Row[])d06商品一覧.D06商品.Select("選択 = True");
            //// 妥協ロジック
            int i選択数 = 0;
            for (int iRow = 0; iRow < dgv商品一覧.RowCount; iRow++)
            {
                if ((Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt選択].Value == true)
                    i選択数++;
            }
            ////チェックがされていなければエラー
            //if (i選択数 < 1)
            //{
            //    MessageBox.Show(string.Format(Properties.Resources.MSG_INF_008, "商品")
            //        , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgv商品一覧.Focus();
            //    return false;
            //}
            if (C01FormCommon.チェック選択数(dgv商品一覧, 商品一覧Cell.byt選択, this.Text
                , Properties.Resources.DGV列名_商品) == false)
                return false;

            //５商品以上チェックがされていなければエラー
            if (i選択数 > 3)
            {
                MessageBox.Show(Properties.Resources.MSG_W_選択されている商品が_３商品を超えています, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);

                dgv商品一覧.Focus();
                return false;
            }

            return true;
        }

        private void Set商品検索結果()
        {
            D06商品一覧.D06商品Row[] dr = (D06商品一覧.D06商品Row[])d06商品一覧.D06商品
                .Select(Properties.Resources.DGV列名_選択 + " = true");

            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                D06商品一覧.D06商品Row dr商品検索結果 = dt商品検索結果.NewD06商品Row();

                dr商品検索結果.商品No = dr[iRow].商品No;
                dr商品検索結果.商品ID = dr[iRow].商品ID;
                dr商品検索結果.商品名 = dr[iRow].商品名;
                dr商品検索結果.商品単価 = dr[iRow].商品単価;

                dt商品検索結果.AddD06商品Row(dr商品検索結果);
            }
        }


        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _203商品一覧_Load(object sender, EventArgs e)
        {
            try
            {
                Set列幅();

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "_203商品一覧_Load", ex);
            }
        }

        private void _203商品一覧_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, false);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "_203商品一覧_Resize", ex);
            }
        }

        private void dgv商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv商品一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv商品一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv商品一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "dgv商品一覧_RowPostPaint", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                txt商品ID.Text = "";
                txt商品名.Text = "";
                txt商品単価.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                d06商品bs.DataSource = null;
                検索条件 row = Get検索条件();
                d06商品ta.FillBy検索条件(d06商品一覧.D06商品, row.商品ID, row.商品名, row.商品単価);

                //選択済みの商品を再選択
                if (mstr選択済み商品No != "" && mstr選択済み商品No != null)
                {
                    D06商品一覧.D06商品Row[] dr = (D06商品一覧.D06商品Row[])d06商品一覧.D06商品
                        .Select(Properties.Resources.DGV列名_商品No + " IN (" + mstr選択済み商品No + ")");

                    for (int iRow = 0; iRow < dr.Length; iRow++)
                        dr[iRow].選択 = true;
                }

                //見つからない場合はメッセージ表示
                if (d06商品一覧.D06商品.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "btn検索_Click", ex);
            }
            finally
            {
                d06商品bs.DataSource = d06商品一覧.D06商品;
				lbl件数.Text = "検索結果：" + d06商品一覧.D06商品.Count.ToString() + " 件";
				Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv商品一覧.SelectedRows)
                    row.Cells[商品一覧Cell.byt選択].Value = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "btn選択行を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv商品一覧.SelectedRows)
                    row.Cells[商品一覧Cell.byt選択].Value = false;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d06商品一覧.D06商品.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn検索結果をクリア_Click", ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                if (false == IsValidate())
                    return;

                Cursor.Current = Cursors.WaitCursor;

                mstr購入済み商品ID = "";
                mstr選択済み商品No = "";

                for (int iRow = 0; iRow < dgv商品一覧.RowCount; iRow++)
                {
                    if ((Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt選択].Value == false)
                        continue;

                    mstr購入済み商品ID += dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt商品ID].Value.ToString() + ", ";
                    mstr選択済み商品No += dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt商品No].Value.ToString() + ",";
                }
                //D06商品一覧.D06商品Row[] dr = (D06商品一覧.D06商品Row[])d06商品一覧.D06商品.Select("選択 = true");
                //for (int iRow = 0; iRow < dr.Length; iRow++)
                //{
                //    mstr購入済み商品ID += C04システム共通.NULLを空文字に変換(dr[iRow].商品ID) + ", ";
                //    mstr購入済み商品No += C04システム共通.NULLを空文字に変換(dr[iRow].商品No.ToString()) + ",";
                //}

                // 最後の不要カンマを削除
                mstr購入済み商品ID = mstr購入済み商品ID.Substring(0, mstr購入済み商品ID.Length - 2);
                mstr選択済み商品No = mstr選択済み商品No.Substring(0, mstr選択済み商品No.Length - 1);

                Set商品検索結果();

                this.DialogResult = DialogResult.OK;
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_203商品一覧", "btnキャンセル_Click", ex);
            }
        }

        #endregion





    }
}
