/******************************************************************************/
/* src/kernel/IntMng/IntMngIdt.h                                              */
/*                                                                 2016/12/18 */
/* Copyright (C) 2016 Mochi.                                                  */
/******************************************************************************/
#ifndef INTMNG_IDT_H
#define INTMNG_IDT_H
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 共通ヘッダ */
#include <stdint.h>


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* IDT定義 */
#define INTMNG_IDT_ENTRY_MIN (   0 )    /**< IDTエントリ番号最小値 */
#define INTMNG_IDT_ENTRY_MAX ( 255 )    /**< IDTエントリ番号最大値 */
#define INTMNG_IDT_ENTRY_NUM \
    ( INTMNG_IDT_ENTRY_MAX + 1 )        /**< IDTエントリ数         */


/******************************************************************************/
/* グローバル関数宣言                                                         */
/******************************************************************************/
/* IDT管理初期化 */
extern void IntMngIdtInit( void );

/* IDTエントリ設定 */
extern void IntMngIdtSet( uint32_t index,
                          uint16_t selector,
                          void     *pOffset,
                          uint8_t  count,
                          uint8_t  type,
                          uint8_t  level );


/******************************************************************************/
#endif
