//
//  HMMemberDeckCommand.m
//  KCD
//
//  Created by Hori,Masaki on 2014/02/21.
//  Copyright (c) 2014年 Hori,Masaki. All rights reserved.
//

#import "HMMemberDeckCommand.h"

/* 
 mission_0:	status
	0:ミッション無し
	1:ミッション中
	2:帰投 (おそらく帰投時のデータ確認用か帰投表示を出すため）
 
 mission_1: maparea_id
 mission_2: 帰投時間
 mission_3: 未使用？
 */

@implementation HMMemberDeckCommand
+ (void)load
{
	static dispatch_once_t onceToken;
	dispatch_once(&onceToken, ^{
		[HMJSONCommand registerClass:self];
	});
}

+ (BOOL)canExcuteAPI:(NSString *)api
{
	if([api isEqualToString:@"/kcsapi/api_get_member/deck"]) return YES;
	if([api isEqualToString:@"/kcsapi/api_get_member/deck_port"]) return YES;
	return NO;
}

- (NSString *)dataKey
{
	if([self.api isEqualToString:@"/kcsapi/api_port/port"]) {
		return @"api_data.api_deck_port";
	}
	return [super dataKey];
}
- (void)execute
{
	[self commitJSONToEntityNamed:@"Deck"];
}
@end
