/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.SessionHolder;
import org.springframework.orm.toplink.TopLinkAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TopLinkInterceptor
extends TopLinkAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        block10: {
            Session session;
            block9: {
                boolean existingTransaction = false;
                session = SessionFactoryUtils.getSession(this.getSessionFactory(), true);
                if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
                    this.logger.debug((Object)"Found thread-bound Session for TopLink interceptor");
                    existingTransaction = true;
                } else {
                    this.logger.debug((Object)"Using new Session for TopLink interceptor");
                    TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
                }
                try {
                    object = methodInvocation.proceed();
                    Object var6_6 = null;
                    if (!existingTransaction) break block9;
                }
                catch (TopLinkException ex) {
                    try {
                        if (this.exceptionConversionEnabled) {
                            throw this.convertTopLinkAccessException(ex);
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (existingTransaction) {
                            this.logger.debug((Object)"Not closing pre-bound TopLink Session after interceptor");
                        } else {
                            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                            SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
                        }
                        throw throwable;
                    }
                }
                this.logger.debug((Object)"Not closing pre-bound TopLink Session after interceptor");
                break block10;
            }
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
        }
        return object;
    }
}

