/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.Base64Util;

public class StringConversionUtil {
    public static final int WAVE_DASH = 12316;
    public static final int FULLWIDTH_TILDE = 65374;

    protected StringConversionUtil() {
    }

    public static String toString(Object value) {
        return StringConversionUtil.toString(value, null);
    }

    public static String toString(Object value, String pattern) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return StringConversionUtil.toString((Date)value, pattern);
        }
        if (value instanceof Number) {
            return StringConversionUtil.toString((Number)value, pattern);
        }
        if (value instanceof byte[]) {
            return Base64Util.encode((byte[])value);
        }
        return value.toString();
    }

    public static String toString(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new DecimalFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String toString(Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new SimpleDateFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String fromWaveDashToFullwidthTilde(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\u301c': {
                    ch = '\uff5e';
                    break;
                }
            }
            result.append(ch);
        }
        return result.toString();
    }
}

