package net.arnx.devtools.service;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileReader;

import javax.imageio.ImageIO;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class ServiceManager {
	public static void main(String[] args) throws Exception {
		ServiceManager sm = new ServiceManager((args.length > 0) ? args[0] : "service.js");
		
		sm.start();
	}
	
	SystemTray tray;
	TrayIcon ti;
	MenuItem mStart = new MenuItem("Start");
	MenuItem mRestart = new MenuItem("Restart");
	MenuItem mStop = new MenuItem("Stop");
	
	ScriptEngine engine;
	
	boolean isStarted = false;
	
	public ServiceManager(String file) throws Exception {
		if (SystemTray.isSupported()) {
			tray = SystemTray.getSystemTray();
		} else {
			throw new UnsupportedOperationException("SystemTray is not supported");
		}
		ti = new TrayIcon(ImageIO.read(getClass().getResourceAsStream("icon.gif")));
		
		ScriptEngineManager sem = new ScriptEngineManager();
		engine = sem.getEngineByName("js");
		
		engine.eval(new FileReader(file));
		
		PopupMenu menu = new PopupMenu();
		
		mStart.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				start();
			}
		});
		menu.add(mStart);
		
		mRestart.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				stop();
				start();
			}
		});
		menu.add(mRestart);
		
		mStop.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				stop();
			}
		});
		menu.add(mStop);
		
		menu.addSeparator();
		
		MenuItem mExit = new MenuItem("Exit");
		mExit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (isStarted) stop();
				
				tray.remove(ti);
			}
		});
		menu.add(mExit);
		
		ti.setPopupMenu(menu);
		tray.add(ti);
	}
	
	public void start() {
		mStart.setEnabled(false);
		mRestart.setEnabled(false);
		mStop.setEnabled(false);
		try {
			((Invocable)engine).invokeFunction("start");
		} catch (Exception e2) {
			e2.printStackTrace();
		}
		mRestart.setEnabled(true);
		mStop.setEnabled(true);
		
		isStarted = true;
	}
	
	public void stop() {
		mStart.setEnabled(false);
		mRestart.setEnabled(false);
		mStop.setEnabled(false);
		try {
			((Invocable)engine).invokeFunction("stop");
		} catch (Exception e2) {
			e2.printStackTrace();
		}
		mStart.setEnabled(true);
		
		isStarted = false;
	}
	
	@Override
	protected void finalize() throws Throwable {
		tray.remove(ti);
		super.finalize();
	}
}
