/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import winstone.Launcher;
import winstone.Logger;

public class WebXmlParser
implements EntityResolver,
ErrorHandler {
    private ClassLoader commonLoader;
    private boolean rethrowValidationExceptions;
    private static final String SCHEMA_SOURCE_PROPERTY = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String[][] LOCAL_ENTITY_TABLE = new String[][]{{"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", null, "javax/servlet/resources/web-app_2_2.dtd"}, {"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", null, "javax/servlet/resources/web-app_2_3.dtd"}, {null, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "javax/servlet/resources/web-app_2_4.xsd"}, {null, "http://java.sun.com/xml/ns/j2ee/web-app_2_5.xsd", "javax/servlet/resources/web-app_2_5.xsd"}, {null, "http://www.w3.org/2001/xml.xsd", "javax/servlet/resources/xml.xsd"}, {"-//W3C//DTD XMLSCHEMA 200102//EN", null, "javax/servlet/resources/XMLSchema.dtd"}, {null, "http://www.w3.org/2001/datatypes.dtd", "javax/servlet/resources/datatypes.dtd"}, {null, "http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", "javax/servlet/resources/j2ee_1_4.xsd"}, {null, "http://java.sun.com/xml/ns/j2ee/javaee_5.xsd", "javax/servlet/resources/javaee_5.xsd"}, {null, "http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", "javax/servlet/resources/jsp_2_0.xsd"}, {null, "http://java.sun.com/xml/ns/j2ee/jsp_2_1.xsd", "javax/servlet/resources/jsp_2_1.xsd"}, {null, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "javax/servlet/resources/j2ee_web_services_client_1_1.xsd"}, {null, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_2.xsd", "javax/servlet/resources/javaee_web_services_client_1_2.xsd"}};

    public WebXmlParser(ClassLoader commonCL) {
        this.commonLoader = commonCL;
        this.rethrowValidationExceptions = true;
    }

    protected Document parseStreamToXML(File webXmlFile) {
        DocumentBuilderFactory factory = this.getBaseDBF();
        URL localXSD25 = this.commonLoader.getResource(LOCAL_ENTITY_TABLE[3][2]);
        URL localXSD24 = this.commonLoader.getResource(LOCAL_ENTITY_TABLE[2][2]);
        try {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            if (localXSD25 != null) {
                factory.setAttribute(SCHEMA_SOURCE_PROPERTY, localXSD25.toString());
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebXmlParser.Local25XSDEnabled");
            } else if (localXSD24 != null) {
                factory.setAttribute(SCHEMA_SOURCE_PROPERTY, localXSD24.toString());
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebXmlParser.Local24XSDEnabled");
            } else {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebXmlParser.2524XSDNotFound");
            }
        }
        catch (Throwable err) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebXmlParser.NonXSDParser");
            try {
                this.rethrowValidationExceptions = false;
                return this.parseAsV23Webapp(webXmlFile);
            }
            catch (Throwable v23Err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebXmlParser.WebXML23ParseError", v23Err);
                return null;
            }
        }
        try {
            if (localXSD25 != null) {
                factory.setAttribute(SCHEMA_SOURCE_PROPERTY, localXSD25.toString());
            } else {
                factory.setAttribute(SCHEMA_SOURCE_PROPERTY, null);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this);
            builder.setErrorHandler(this);
            this.rethrowValidationExceptions = true;
            return builder.parse(webXmlFile);
        }
        catch (Throwable errV25) {
            try {
                if (localXSD24 != null) {
                    factory.setAttribute(SCHEMA_SOURCE_PROPERTY, localXSD24.toString());
                } else {
                    factory.setAttribute(SCHEMA_SOURCE_PROPERTY, null);
                }
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(this);
                builder.setErrorHandler(this);
                this.rethrowValidationExceptions = true;
                return builder.parse(webXmlFile);
            }
            catch (Throwable errV24) {
                try {
                    this.rethrowValidationExceptions = false;
                    return this.parseAsV23Webapp(webXmlFile);
                }
                catch (Throwable errV23) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebXmlParser.WebXMLBothErrors");
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebXmlParser.WebXML25ParseError", errV25);
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebXmlParser.WebXML24ParseError", errV24);
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebXmlParser.WebXML23ParseError", errV23);
                    return null;
                }
            }
        }
    }

    private Document parseAsV23Webapp(File webXmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = this.getBaseDBF();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this);
        builder.setErrorHandler(this);
        return builder.parse(webXmlFile);
    }

    private DocumentBuilderFactory getBaseDBF() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setIgnoringElementContentWhitespace(true);
        return factory;
    }

    public InputSource resolveEntity(String publicName, String url) throws SAXException, IOException {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebXmlParser.ResolvingEntity", new String[]{publicName, url});
        for (int n = 0; n < LOCAL_ENTITY_TABLE.length; ++n) {
            if ((LOCAL_ENTITY_TABLE[n][0] == null || publicName == null || !publicName.equals(LOCAL_ENTITY_TABLE[n][0])) && (LOCAL_ENTITY_TABLE[n][1] == null || url == null || !url.equals(LOCAL_ENTITY_TABLE[n][1])) || this.commonLoader.getResource(LOCAL_ENTITY_TABLE[n][2]) == null) continue;
            return this.getLocalResource(url, LOCAL_ENTITY_TABLE[n][2]);
        }
        if (url != null && url.startsWith("jar:")) {
            return this.getLocalResource(url, url.substring(url.indexOf("!/") + 2));
        }
        if (url != null && url.startsWith("file:")) {
            return new InputSource(url);
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebXmlParser.NoLocalResource", url);
        return new InputSource(url);
    }

    private InputSource getLocalResource(String url, String local) {
        if (this.commonLoader.getResource(local) == null) {
            return new InputSource(url);
        }
        InputSource is = new InputSource(this.commonLoader.getResourceAsStream(local));
        is.setSystemId(url);
        return is;
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.rethrowValidationExceptions) {
            throw exception;
        }
        Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebXmlParser.XMLParseError", new String[]{exception.getLineNumber() + "", exception.getMessage()});
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.error(exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebXmlParser.XMLParseError", new String[]{exception.getLineNumber() + "", exception.getMessage()});
    }
}

