/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IORuntimeException;

public final class SerializeUtil {
    private static final int BYTE_ARRAY_SIZE = 8192;

    private SerializeUtil() {
    }

    public static Object serialize(Object o) throws IORuntimeException, ClassNotFoundRuntimeException {
        byte[] binary = SerializeUtil.fromObjectToBinary(o);
        return SerializeUtil.fromBinaryToObject(binary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fromObjectToBinary(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(o);
            }
            finally {
                oos.close();
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromBinaryToObject(byte[] binary) {
        Object object;
        ByteArrayInputStream bais = new ByteArrayInputStream(binary);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundRuntimeException(ex);
            }
        }
        ois.close();
        return object;
    }
}

