/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import [Ljava.lang.Class;;
import [Ljava.lang.String;;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class BeanUtils {
    private static final Log logger = LogFactory.getLog((Class)BeanUtils.class);
    private static final Map unknownEditorTypes = Collections.synchronizedMap(new WeakHashMap());

    public static Object instantiateClass(Class clazz) throws BeanInstantiationException {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        try {
            return BeanUtils.instantiateClass(clazz.getDeclaredConstructor(null), null);
        }
        catch (NoSuchMethodException ex) {
            throw new BeanInstantiationException(clazz, "No default constructor found", ex);
        }
    }

    public static Object instantiateClass(Constructor ctor, Object[] args) throws BeanInstantiationException {
        Assert.notNull(ctor, "Constructor must not be null");
        try {
            ReflectionUtils.makeAccessible(ctor);
            return ctor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", ex.getTargetException());
        }
    }

    public static Method findMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            if (clazz.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, methodName);
        }
        return targetMethod;
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz.getSuperclass() != null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    private static Method doFindMethodWithMinimalParameters(Method[] methods, String methodName) throws IllegalArgumentException {
        Method targetMethod = null;
        int numMethodsFoundWithCurrentMinimumArgs = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            int numParams = methods[i].getParameterTypes().length;
            if (targetMethod == null || numParams < targetMethod.getParameterTypes().length) {
                targetMethod = methods[i];
                numMethodsFoundWithCurrentMinimumArgs = 1;
                continue;
            }
            if (targetMethod.getParameterTypes().length != numParams) continue;
            ++numMethodsFoundWithCurrentMinimumArgs;
        }
        if (numMethodsFoundWithCurrentMinimumArgs > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + methodName + "' to a unique method. Attempted to resolve to overloaded method with " + "the least number of parameters, but there were " + numMethodsFoundWithCurrentMinimumArgs + " candidates.");
        }
        return targetMethod;
    }

    public static Method resolveSignature(String signature, Class clazz) {
        Assert.hasText(signature, "'signature' must not be empty");
        Assert.notNull(clazz, "Class must not be null");
        int firstParen = signature.indexOf("(");
        int lastParen = signature.indexOf(")");
        if (firstParen > -1 && lastParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature + "': expected closing ')' for args list");
        }
        if (lastParen > -1 && firstParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature + "': expected opening '(' for args list");
        }
        if (firstParen == -1 && lastParen == -1) {
            return BeanUtils.findMethodWithMinimalParameters(clazz, signature);
        }
        String methodName = signature.substring(0, firstParen);
        String[] parameterTypeNames = StringUtils.commaDelimitedListToStringArray(signature.substring(firstParen + 1, lastParen));
        Class[] parameterTypes = new Class[parameterTypeNames.length];
        for (int i = 0; i < parameterTypeNames.length; ++i) {
            String parameterTypeName = parameterTypeNames[i].trim();
            try {
                parameterTypes[i] = ClassUtils.forName(parameterTypeName, clazz.getClassLoader());
                continue;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Invalid method signature: unable to resolve type [" + parameterTypeName + "] for argument " + i + ". Root cause: " + ex);
            }
        }
        return BeanUtils.findMethod(clazz, methodName, parameterTypes);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz);
        return cr.getBeanInfo().getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String propertyName) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz);
        return cr.getPropertyDescriptor(propertyName);
    }

    public static PropertyDescriptor findPropertyForMethod(Method method) throws BeansException {
        Assert.notNull(method, "Method must not be null");
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(method.getDeclaringClass());
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            if (!method.equals(pd.getReadMethod()) && !method.equals(pd.getWriteMethod())) continue;
            return pd;
        }
        return null;
    }

    public static PropertyEditor findEditorByConvention(Class targetType) {
        if (targetType == null || unknownEditorTypes.containsKey(targetType)) {
            return null;
        }
        ClassLoader cl = targetType.getClassLoader();
        if (cl == null && (cl = ClassLoader.getSystemClassLoader()) == null) {
            return null;
        }
        String editorName = targetType.getName() + "Editor";
        try {
            Class<?> editorClass = cl.loadClass(editorName);
            if (!PropertyEditor.class.isAssignableFrom(editorClass)) {
                logger.warn((Object)("Editor class [" + editorName + "] does not implement [java.beans.PropertyEditor] interface"));
                unknownEditorTypes.put(targetType, Boolean.TRUE);
                return null;
            }
            return (PropertyEditor)BeanUtils.instantiateClass(editorClass);
        }
        catch (ClassNotFoundException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No property editor [" + editorName + "] found for type " + targetType.getName() + " according to 'Editor' suffix convention"));
            }
            unknownEditorTypes.put(targetType, Boolean.TRUE);
            return null;
        }
    }

    public static Class findPropertyType(String propertyName, Class[] beanClasses) {
        if (beanClasses != null) {
            for (int i = 0; i < beanClasses.length; ++i) {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(beanClasses[i], propertyName);
                if (pd == null) continue;
                return pd.getPropertyType();
            }
        }
        return Object.class;
    }

    public static MethodParameter getWriteMethodParameter(PropertyDescriptor pd) {
        if (pd instanceof GenericTypeAwarePropertyDescriptor) {
            return new MethodParameter(((GenericTypeAwarePropertyDescriptor)pd).getWriteMethodParameter());
        }
        return new MethodParameter(pd.getWriteMethod(), 0);
    }

    public static boolean isSimpleProperty(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveArray(clazz) || ClassUtils.isPrimitiveWrapper(clazz) || ClassUtils.isPrimitiveWrapperArray(clazz) || clazz.equals(String.class) || clazz.equals(String;.class) || clazz.equals(Class.class) || clazz.equals(Class;.class);
    }

    public static boolean isAssignable(Class targetType, Class valueType) {
        return ClassUtils.isAssignable(targetType, valueType);
    }

    public static boolean isAssignable(Class type, Object value) {
        return ClassUtils.isAssignableValue(type, value);
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        BeanUtils.copyProperties(source, target, null, null);
    }

    public static void copyProperties(Object source, Object target, Class editable) throws BeansException {
        BeanUtils.copyProperties(source, target, editable, null);
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) throws BeansException {
        BeanUtils.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class editable, String[] ignoreProperties) throws BeansException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target, "Target must not be null");
        Class actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (int i = 0; i < targetPds.length; ++i) {
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = targetPds[i];
            if (targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
                continue;
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }
}

