/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.IllegalBindingTypeDefRuntimeException;
import org.seasar.framework.container.assembler.BindingTypeMayDef;
import org.seasar.framework.container.assembler.BindingTypeMustDef;
import org.seasar.framework.container.assembler.BindingTypeNoneDef;
import org.seasar.framework.container.assembler.BindingTypeShouldDef;

public final class BindingTypeDefFactory {
    public static final BindingTypeDef MUST = new BindingTypeMustDef("must");
    public static final BindingTypeDef SHOULD = new BindingTypeShouldDef("should");
    public static final BindingTypeDef MAY = new BindingTypeMayDef("may");
    public static final BindingTypeDef NONE = new BindingTypeNoneDef("none");
    private static Map bindingTypeDefs = new HashMap();

    private BindingTypeDefFactory() {
    }

    public static void addBindingTypeDef(BindingTypeDef bindingTypeDef) {
        bindingTypeDefs.put(bindingTypeDef.getName(), bindingTypeDef);
    }

    public static boolean existBindingTypeDef(String name) {
        return bindingTypeDefs.containsKey(name);
    }

    public static BindingTypeDef getBindingTypeDef(String name) {
        if (!BindingTypeDefFactory.existBindingTypeDef(name)) {
            throw new IllegalBindingTypeDefRuntimeException(name);
        }
        return (BindingTypeDef)bindingTypeDefs.get(name);
    }

    static {
        BindingTypeDefFactory.addBindingTypeDef(MUST);
        BindingTypeDefFactory.addBindingTypeDef(SHOULD);
        BindingTypeDefFactory.addBindingTypeDef(MAY);
        BindingTypeDefFactory.addBindingTypeDef(NONE);
    }
}

