/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.SIllegalArgumentException;
import org.seasar.framework.util.MethodUtil;

public final class FieldUtil {
    protected static final String REFLECTION_UTIL_CLASS_NAME = "org.seasar.framework.util.tiger.ReflectionUtil";
    protected static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD = FieldUtil.getElementTypeFromFieldTypeMethod("Collection");
    protected static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD = FieldUtil.getElementTypeFromFieldTypeMethod("List");
    protected static final Method GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD = FieldUtil.getElementTypeFromFieldTypeMethod("Set");

    private FieldUtil() {
    }

    public static Object get(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static int getInt(Field field) throws IllegalAccessRuntimeException {
        return FieldUtil.getInt(field, null);
    }

    public static int getInt(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return field.getInt(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static String getString(Field field) throws IllegalAccessRuntimeException {
        return FieldUtil.getString(field, null);
    }

    public static String getString(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return (String)field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static void set(Field field, Object target, Object value) throws IllegalAccessRuntimeException {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), e);
        }
        catch (IllegalArgumentException e) {
            throw new SIllegalArgumentException("ESSR0094", new Object[]{field.getDeclaringClass().getName(), field.getName(), value, target == null ? null : target.getClass().getName()}, e);
        }
    }

    public static boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    public static boolean isPublicField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod);
    }

    public static Class getElementTypeOfCollectionFromFieldType(Field field) {
        if (GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
    }

    public static Class getElementTypeOfListFromFieldType(Field field) {
        if (GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
    }

    public static Class getElementTypeOfSetFromFieldType(Field field) {
        if (GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
    }

    protected static Method getElementTypeFromFieldTypeMethod(String type) {
        try {
            Class<?> reflectionUtilClass = Class.forName(REFLECTION_UTIL_CLASS_NAME);
            return reflectionUtilClass.getMethod("getElementTypeOf" + type + "FromFieldType", Field.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

