/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.TestIntrospector;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.interceptors.MockInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.env.Env;
import org.seasar.framework.unit.Expression;
import org.seasar.framework.unit.InternalTestContext;
import org.seasar.framework.unit.S2TestIntrospector;
import org.seasar.framework.unit.annotation.Mock;
import org.seasar.framework.unit.annotation.Mocks;
import org.seasar.framework.unit.annotation.Prerequisite;
import org.seasar.framework.unit.annotation.RegisterNamingConvention;
import org.seasar.framework.unit.annotation.RootDicon;
import org.seasar.framework.unit.annotation.TxBehavior;
import org.seasar.framework.unit.annotation.TxBehaviorType;
import org.seasar.framework.unit.annotation.WarmDeploy;
import org.seasar.framework.unit.impl.OgnlExpression;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTestIntrospector
implements S2TestIntrospector {
    protected Class<? extends Annotation> beforeClassAnnotation = BeforeClass.class;
    protected Class<? extends Annotation> afterClassAnnotation = AfterClass.class;
    protected Class<? extends Annotation> beforeAnnotation = Before.class;
    protected Class<? extends Annotation> afterAnnotation = After.class;
    protected boolean enableIgnore = true;
    protected boolean enablePrerequisite = true;

    public void setBeforeClassAnnotation(Class<? extends Annotation> beforeClassAnnotation) {
        this.beforeClassAnnotation = beforeClassAnnotation;
    }

    public void setAfterClassAnnotation(Class<? extends Annotation> afterClassAnnotation) {
        this.afterClassAnnotation = afterClassAnnotation;
    }

    public void setBeforeAnnotation(Class<? extends Annotation> beforeAnnotation) {
        this.beforeAnnotation = beforeAnnotation;
    }

    public void setAfterAnnotation(Class<? extends Annotation> afterAnnotation) {
        this.afterAnnotation = afterAnnotation;
    }

    public void setEnableIgnore(boolean enableIgnore) {
        this.enableIgnore = enableIgnore;
    }

    public void setEnablePrerequisite(boolean enablePrerequisite) {
        this.enablePrerequisite = enablePrerequisite;
    }

    @Override
    public List<Method> getBeforeClassMethods(Class<?> clazz) {
        return new TestIntrospector(clazz).getTestMethods(this.beforeClassAnnotation);
    }

    @Override
    public List<Method> getAfterClassMethods(Class<?> clazz) {
        return new TestIntrospector(clazz).getTestMethods(this.afterClassAnnotation);
    }

    @Override
    public List<Method> getBeforeMethods(Class<?> clazz) {
        return new TestIntrospector(clazz).getTestMethods(this.beforeAnnotation);
    }

    @Override
    public List<Method> getAfterMethods(Class<?> clazz) {
        return new TestIntrospector(clazz).getTestMethods(this.afterAnnotation);
    }

    @Override
    public List<Method> getTestMethods(Class<?> clazz) {
        return new TestIntrospector(clazz).getTestMethods(Test.class);
    }

    @Override
    public Method getEachBeforeMethod(Class<?> clazz, Method method) {
        return null;
    }

    @Override
    public Method getEachAfterMethod(Class<?> clazz, Method method) {
        return null;
    }

    @Override
    public Method getEachRecordMethod(Class<?> clazz, Method method) {
        return null;
    }

    @Override
    public Class<? extends Throwable> expectedException(Method method) {
        Test annotation = method.getAnnotation(Test.class);
        if (annotation == null || annotation.expected() == Test.None.class) {
            return null;
        }
        return annotation.expected();
    }

    @Override
    public long getTimeout(Method method) {
        Test annotation = method.getAnnotation(Test.class);
        if (annotation != null) {
            return annotation.timeout();
        }
        return 0L;
    }

    @Override
    public boolean isIgnored(Method method) {
        if (this.enableIgnore) {
            return method.isAnnotationPresent(Ignore.class);
        }
        return false;
    }

    @Override
    public boolean isFulfilled(Class<?> clazz, Method method, Object test) {
        String source;
        Expression exp;
        if (!this.enablePrerequisite) {
            return true;
        }
        if (clazz.isAnnotationPresent(Prerequisite.class) && !this.isFulfilled(exp = this.createExpression(source = clazz.getAnnotation(Prerequisite.class).value(), method, test))) {
            return false;
        }
        return !method.isAnnotationPresent(Prerequisite.class) || this.isFulfilled(exp = this.createExpression(source = method.getAnnotation(Prerequisite.class).value(), method, test));
    }

    protected boolean isFulfilled(Expression expression) {
        Object result = expression.evaluateNoException();
        if (expression.isMethodFailed()) {
            System.err.println(expression.getException());
            return false;
        }
        expression.throwExceptionIfNecessary();
        return result instanceof Boolean && (Boolean)Boolean.class.cast(result) != false;
    }

    @Override
    public boolean needsTransaction(Class<?> clazz, Method method) {
        TxBehaviorType type = this.getTxBehaviorType(clazz, method);
        return type == null || type != TxBehaviorType.NONE;
    }

    @Override
    public boolean requiresTransactionCommitment(Class<?> clazz, Method method) {
        TxBehaviorType type = this.getTxBehaviorType(clazz, method);
        return type != null && type == TxBehaviorType.COMMIT;
    }

    protected TxBehaviorType getTxBehaviorType(Class<?> clazz, Method method) {
        if (method.isAnnotationPresent(TxBehavior.class)) {
            return method.getAnnotation(TxBehavior.class).value();
        }
        if (clazz.isAnnotationPresent(TxBehavior.class)) {
            return clazz.getAnnotation(TxBehavior.class).value();
        }
        return null;
    }

    @Override
    public boolean needsWarmDeploy(Class<?> clazz, Method method) {
        if (method.isAnnotationPresent(WarmDeploy.class)) {
            return method.getAnnotation(WarmDeploy.class).value();
        }
        if (clazz.isAnnotationPresent(WarmDeploy.class)) {
            return clazz.getAnnotation(WarmDeploy.class).value();
        }
        return true;
    }

    @Override
    public boolean isRegisterNamingConvention(Class<?> clazz, Method method) {
        if (method.isAnnotationPresent(RegisterNamingConvention.class)) {
            return method.getAnnotation(RegisterNamingConvention.class).value();
        }
        if (clazz.isAnnotationPresent(RegisterNamingConvention.class)) {
            return clazz.getAnnotation(RegisterNamingConvention.class).value();
        }
        return true;
    }

    @Override
    public void createMock(Method method, Object test, InternalTestContext context) {
        Mock mock = method.getAnnotation(Mock.class);
        if (mock != null) {
            this.createMock(mock, method, test, context);
        } else {
            Mocks mocks = method.getAnnotation(Mocks.class);
            if (mocks != null) {
                for (Mock each : mocks.value()) {
                    this.createMock(each, method, test, context);
                }
            }
        }
    }

    protected void createMock(Mock mock, Method method, Object test, InternalTestContext context) {
        Expression exp;
        MockInterceptor mi = new MockInterceptor();
        if (!StringUtil.isEmpty((String)mock.returnValue())) {
            exp = this.createExpression(mock.returnValue(), method, test);
            mi.setReturnValue(exp.evaluate());
        }
        if (!StringUtil.isEmpty((String)mock.throwable())) {
            exp = this.createExpression(mock.throwable(), method, test);
            Object result = exp.evaluate();
            mi.setThrowable((Throwable)Throwable.class.cast(result));
        }
        Pointcut pc = null;
        pc = StringUtil.isEmpty((String)mock.pointcut()) ? AspectDefFactory.createPointcut(mock.target()) : AspectDefFactory.createPointcut((String)mock.pointcut());
        Object componentKey = StringUtil.isEmpty((String)mock.targetName()) ? mock.target() : mock.targetName();
        AspectDef aspectDef = AspectDefFactory.createAspectDef((MethodInterceptor)mi, (Pointcut)pc);
        context.addAspecDef(componentKey, aspectDef);
        context.addMockInterceptor(mi);
    }

    protected Expression createExpression(String source, Method method, Object test) {
        HashMap<String, Object> ctx = CollectionsUtil.newHashMap();
        ctx.put("ENV", Env.getValue());
        ctx.put("method", method);
        return new OgnlExpression(source, test, ctx);
    }

    @Override
    public String getRootDicon(Class<?> clazz, Method method) {
        if (method.isAnnotationPresent(RootDicon.class)) {
            return method.getAnnotation(RootDicon.class).value();
        }
        if (clazz.isAnnotationPresent(RootDicon.class)) {
            return clazz.getAnnotation(RootDicon.class).value();
        }
        return null;
    }
}

