/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.meta;

import javax.persistence.Table;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.TableMeta;
import org.seasar.extension.jdbc.TableMetaFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetaFactoryImpl
implements TableMetaFactory {
    private PersistenceConvention persistenceConvention;

    @Override
    public TableMeta createTableMeta(Class<?> entityClass, EntityMeta entityMeta) {
        TableMeta tableMeta = new TableMeta();
        String defaultName = this.persistenceConvention.fromEntityNameToTableName(entityMeta.getName());
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null) {
            String name = table.name();
            if (StringUtil.isEmpty((String)name)) {
                name = defaultName;
            }
            tableMeta.setName(name);
            String schema = table.schema();
            if (!StringUtil.isEmpty((String)schema)) {
                tableMeta.setSchema(schema);
            }
        } else {
            tableMeta.setName(defaultName);
        }
        return tableMeta;
    }

    public PersistenceConvention getPersistenceConvention() {
        return this.persistenceConvention;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceConvention(PersistenceConvention persistenceConvention) {
        this.persistenceConvention = persistenceConvention;
    }
}

