/*
 * Decompiled with CFR 0.152.
 */
package winstone.ajp13;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import winstone.Logger;
import winstone.RequestHandlerThread;
import winstone.WinstoneException;
import winstone.ajp13.Ajp13Listener;

public class Ajp13IncomingPacket {
    byte SERVER_FORWARD_REQUEST = (byte)2;
    private int packetLength;
    private byte[] packetBytes;
    private byte packetType;
    private String method;
    private String protocol;
    private String uri;
    private String remoteAddr;
    private String remoteHost;
    private String serverName;
    private int serverPort;
    private boolean isSSL;
    private String[] headers;
    private Map attributes;

    public Ajp13IncomingPacket(InputStream in, RequestHandlerThread handler) throws IOException {
        byte[] headerBuffer = new byte[4];
        int headerBytesRead = in.read(headerBuffer);
        handler.setRequestStartTime();
        if (headerBytesRead != 4) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.InvalidHeader"));
        }
        if (headerBuffer[0] != 18 || headerBuffer[1] != 52) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.InvalidHeader"));
        }
        this.packetLength = ((headerBuffer[2] & 0xFF) << 8) + (headerBuffer[3] & 0xFF);
        this.packetBytes = new byte[this.packetLength];
        int packetBytesRead = in.read(this.packetBytes);
        if (packetBytesRead < this.packetLength) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.ShortPacket"));
        }
    }

    public byte parsePacket(String encoding) throws IOException {
        int position = 0;
        this.packetType = this.packetBytes[position++];
        if (this.packetType != this.SERVER_FORWARD_REQUEST) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.UnknownPacketType", this.packetType + ""));
        }
        if (this.packetBytes[this.packetLength - 1] != -1) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.InvalidTerminator"));
        }
        this.method = this.decodeMethodType(this.packetBytes[position++]);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Method", this.method);
        int protocolLength = this.readInteger(position, this.packetBytes, true);
        this.protocol = protocolLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, protocolLength) : null;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Protocol", this.protocol);
        int uriLength = this.readInteger(position += protocolLength + 1, this.packetBytes, true);
        this.uri = uriLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, uriLength) : null;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.URI", this.uri);
        int remoteAddrLength = this.readInteger(position += uriLength + 1, this.packetBytes, true);
        this.remoteAddr = remoteAddrLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, remoteAddrLength) : null;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.RemoteAddress", this.remoteAddr);
        int remoteHostLength = this.readInteger(position += remoteAddrLength + 1, this.packetBytes, true);
        this.remoteHost = remoteHostLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, remoteHostLength) : null;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.RemoteHost", this.remoteHost);
        int serverNameLength = this.readInteger(position += remoteHostLength + 1, this.packetBytes, true);
        this.serverName = serverNameLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, serverNameLength) : null;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.ServerName", this.serverName);
        this.serverPort = this.readInteger(position += serverNameLength + 1, this.packetBytes, false);
        position += 2;
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.ServerPort", "" + this.serverPort);
        this.isSSL = this.readBoolean(position++, this.packetBytes);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.SSL", "" + this.isSSL);
        int headerCount = this.readInteger(position, this.packetBytes, false);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.HeaderCount", "" + headerCount);
        position += 2;
        this.headers = new String[headerCount];
        for (int n = 0; n < headerCount; ++n) {
            int headerTypeOrLength = this.readInteger(position, this.packetBytes, false);
            String headerName = null;
            if (this.packetBytes[(position += 2) - 2] == -96) {
                headerName = this.decodeHeaderType(headerTypeOrLength);
            } else {
                headerName = this.readString(position, this.packetBytes, encoding, headerTypeOrLength);
                position += headerTypeOrLength + 1;
            }
            int headerValueLength = this.readInteger(position, this.packetBytes, true);
            this.headers[n] = headerName + ": " + (headerValueLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, headerValueLength) : "");
            position += headerValueLength + 1;
            Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Header", this.headers[n]);
        }
        this.attributes = new Hashtable();
        while (position < this.packetLength - 2) {
            String attName = this.decodeAttributeType(this.packetBytes[position++]);
            int attValueLength = this.readInteger(position, this.packetBytes, true);
            String attValue = attValueLength > -1 ? this.readString(position += 2, this.packetBytes, encoding, attValueLength) : null;
            position += attValueLength + 1;
            this.attributes.put(attName, attValue);
            Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Attribute", new String[]{attName, attValue});
        }
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.SuccessfullyReadRequest", "" + this.packetLength);
        return this.packetType;
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getURI() {
        return this.uri;
    }

    public String getRemoteAddress() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    private int readInteger(int position, byte[] packet, boolean forStringLength) {
        if (forStringLength && packet[position] == -1 && packet[position + 1] == -1) {
            return -1;
        }
        return ((packet[position] & 0xFF) << 8) + (packet[position + 1] & 0xFF);
    }

    private boolean readBoolean(int position, byte[] packet) {
        return packet[position] == 1;
    }

    private String readString(int position, byte[] packet, String encoding, int length) throws UnsupportedEncodingException {
        return length == 0 ? "" : new String(packet, position, length, encoding);
    }

    private String decodeMethodType(byte methodType) {
        switch (methodType) {
            case 1: {
                return "OPTIONS";
            }
            case 2: {
                return "GET";
            }
            case 3: {
                return "HEAD";
            }
            case 4: {
                return "POST";
            }
            case 5: {
                return "PUT";
            }
            case 6: {
                return "DELETE";
            }
            case 7: {
                return "TRACE";
            }
            case 8: {
                return "PROPFIND";
            }
            case 9: {
                return "PROPPATCH";
            }
            case 10: {
                return "MKCOL";
            }
            case 11: {
                return "COPY";
            }
            case 12: {
                return "MOVE";
            }
            case 13: {
                return "LOCK";
            }
            case 14: {
                return "UNLOCK";
            }
            case 15: {
                return "ACL";
            }
            case 16: {
                return "REPORT";
            }
            case 17: {
                return "VERSION-CONTROL";
            }
            case 18: {
                return "CHECKIN";
            }
            case 19: {
                return "CHECKOUT";
            }
            case 20: {
                return "UNCHECKOUT";
            }
            case 21: {
                return "SEARCH";
            }
            case 22: {
                return "MKWORKSPACE";
            }
            case 23: {
                return "UPDATE";
            }
            case 24: {
                return "LABEL";
            }
            case 25: {
                return "MERGE";
            }
            case 26: {
                return "BASELINE_CONTROL";
            }
            case 27: {
                return "MKACTIVITY";
            }
        }
        return "UNKNOWN";
    }

    private String decodeHeaderType(int headerType) {
        switch (headerType) {
            case 40961: {
                return "Accept";
            }
            case 40962: {
                return "Accept-Charset";
            }
            case 40963: {
                return "Accept-Encoding";
            }
            case 40964: {
                return "Accept-Language";
            }
            case 40965: {
                return "Authorization";
            }
            case 40966: {
                return "Connection";
            }
            case 40967: {
                return "Content-Type";
            }
            case 40968: {
                return "Content-Length";
            }
            case 40969: {
                return "Cookie";
            }
            case 40970: {
                return "Cookie2";
            }
            case 40971: {
                return "Host";
            }
            case 40972: {
                return "Pragma";
            }
            case 40973: {
                return "Referer";
            }
            case 40974: {
                return "User-Agent";
            }
        }
        return null;
    }

    private String decodeAttributeType(byte attributeType) {
        switch (attributeType) {
            case 1: {
                return "context";
            }
            case 2: {
                return "servlet_path";
            }
            case 3: {
                return "remote_user";
            }
            case 4: {
                return "auth_type";
            }
            case 5: {
                return "query_string";
            }
            case 6: {
                return "jvm_route";
            }
            case 7: {
                return "ssl_cert";
            }
            case 8: {
                return "ssl_cipher";
            }
            case 9: {
                return "ssl_session";
            }
            case 10: {
                return "req_attribute";
            }
        }
        return null;
    }
}

