/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.autodetector;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.seasar.framework.autodetector.impl.AbstractResourceAutoDetector;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceTraversal;

@Component
public class MappingFileAutoDetector
extends AbstractResourceAutoDetector {
    protected NamingConvention namingConvention;

    public MappingFileAutoDetector() {
        this.addTargetDirPath("META-INF");
        this.addResourceNamePattern(".*Orm.xml");
    }

    @Binding(bindingType=BindingType.MAY)
    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    @InitMethod
    public void init() {
        if (this.namingConvention != null) {
            String entityPackageName = this.namingConvention.getEntityPackageName();
            String daoPackageName = this.namingConvention.getDaoPackageName();
            this.addTargetPackageName(entityPackageName);
            this.addTargetPackageName(daoPackageName);
        }
    }

    protected void addTargetPackageName(String packageName) {
        for (String rootPackageName : this.namingConvention.getRootPackageNames()) {
            String concatedPackageName = ClassUtil.concatName((String)rootPackageName, (String)packageName);
            this.addTargetDirPath(concatedPackageName.replace(".", "/"));
        }
    }

    public void detect(ResourceTraversal.ResourceHandler handler) {
        for (int i = 0; i < this.getTargetDirPathSize(); ++i) {
            String targetDirPath = this.getTargetDirPath(i);
            Iterator it = ClassLoaderUtil.getResources((String)targetDirPath);
            while (it.hasNext()) {
                URL targetDirUrl = (URL)it.next();
                this.detect(handler, targetDirPath, targetDirUrl);
            }
        }
    }

    protected void detect(final ResourceTraversal.ResourceHandler handler, final String targetDirPath, URL targetDirUrl) {
        AbstractResourceAutoDetector.Strategy strategy = this.getStrategy(targetDirUrl.getProtocol());
        strategy.detect(targetDirPath, targetDirUrl, new ResourceTraversal.ResourceHandler(){

            public void processResource(String path, InputStream is) {
                if (path.startsWith(targetDirPath) && MappingFileAutoDetector.this.isApplied(path) && !MappingFileAutoDetector.this.isIgnored(path)) {
                    handler.processResource(path, is);
                }
            }
        });
    }
}

