/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import java.util.List;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.dialect.StandardDialect;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends StandardDialect {
    private boolean supportsBooleanToInt = true;
    private boolean supportsWaveDashToFullwidthTilde = true;

    @Override
    public String getName() {
        return "oracle";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsBooleanToInt() {
        return this.supportsBooleanToInt;
    }

    public boolean supportsWaveDashToFullwidthTilde() {
        return this.supportsWaveDashToFullwidthTilde;
    }

    @Override
    public boolean needsParameterForResultSet() {
        return true;
    }

    @Override
    public String convertLimitSql(String sql, int offset, int limit) {
        boolean hasOffset;
        StringBuilder buf = new StringBuilder(sql.length() + 100);
        sql = sql.trim();
        String lowerSql = sql.toLowerCase();
        boolean isForUpdate = false;
        if (lowerSql.endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        boolean bl = hasOffset = offset > 0;
        if (hasOffset) {
            buf.append("select * from ( select temp_.*, rownum rownumber_ from ( ");
            buf.append(sql);
            buf.append(" ) temp_");
            if (limit > 0) {
                buf.append(" where rownum <= ");
                buf.append(offset + limit);
            }
            buf.append(" ) where rownumber_ > ");
            buf.append(offset);
        } else {
            buf.append("select * from ( ");
            buf.append(sql);
            buf.append(" ) where rownum <= ");
            buf.append(limit);
        }
        if (isForUpdate) {
            buf.append(" for update");
        }
        return buf.toString();
    }

    @Override
    public ValueType getValueType(PropertyMeta propertyMeta) {
        ValueType valueType = this.getValueTypeInternal(propertyMeta.getPropertyClass());
        if (valueType != null) {
            return valueType;
        }
        return super.getValueType(propertyMeta);
    }

    @Override
    protected ValueType getValueTypeInternal(Class<?> clazz) {
        if (clazz == String.class && this.supportsWaveDashToFullwidthTilde()) {
            return ValueTypes.WAVE_DASH_STRING;
        }
        if ((clazz == Boolean.class || clazz == Boolean.TYPE) && this.supportsBooleanToInt()) {
            return ValueTypes.BOOLEAN_INTEGER;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ValueTypes.ORACLE_RESULT_SET;
        }
        return null;
    }

    public void setSupportsBooleanToInt(boolean supportsBooleanToInt) {
        this.supportsBooleanToInt = supportsBooleanToInt;
    }

    public void setSupportsWaveDashToFullwidthTilde(boolean supportsWaveDashToFullwidthTilde) {
        this.supportsWaveDashToFullwidthTilde = supportsWaveDashToFullwidthTilde;
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return true;
    }

    @Override
    public String getForUpdateString(SelectForUpdateType type, int waitSeconds, Pair<String, String> ... aliases) {
        StringBuilder buf = new StringBuilder(100).append(" for update");
        if (aliases.length > 0) {
            buf.append(" of ");
            for (Pair<String, String> alias : aliases) {
                buf.append(alias.getFirst()).append('.').append(alias.getSecond()).append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        switch (type) {
            case NORMAL: {
                break;
            }
            case NOWAIT: {
                buf.append(" nowait");
                break;
            }
            case WAIT: {
                buf.append(" wait ").append(waitSeconds);
            }
        }
        return new String(buf);
    }

    @Override
    public String getHintComment(String hint) {
        return "/*+ " + hint + " */ ";
    }
}

