/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.dialect.StandardDialect;

public class MysqlDialect
extends StandardDialect {
    public String getName() {
        return "mysql";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffsetWithoutLimit() {
        return false;
    }

    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 20);
        buf.append(sql);
        if (offset > 0 && limit > 0) {
            buf.append(" limit ");
            buf.append(offset);
            buf.append(", ");
            buf.append(limit);
        } else if (offset == 0 && limit > 0) {
            buf.append(" limit ");
            buf.append(limit);
        } else if (offset > 0 && limit == 0) {
            throw new IllegalArgumentException("limit is zero");
        }
        return buf.toString();
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }
}

