/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.EnumerationIterator;
import org.seasar.framework.util.MethodUtil;

public abstract class ClassLoaderUtil {
    private static final Method findLoadedClassMethod = ClassLoaderUtil.getFindLoadedClassMethod();
    private static final Method defineClassMethod = ClassLoaderUtil.getDefineClassMethod();
    private static final Method definePackageMethod = ClassLoaderUtil.getDefinePackageMethod();

    private ClassLoaderUtil() {
    }

    private static Method getFindLoadedClassMethod() {
        Method method = ClassUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", new Class[]{String.class});
        method.setAccessible(true);
        return method;
    }

    private static Method getDefineClassMethod() {
        Method method = ClassUtil.getDeclaredMethod(ClassLoader.class, "defineClass", new Class[]{String.class, [B.class, Integer.TYPE, Integer.TYPE});
        method.setAccessible(true);
        return method;
    }

    private static Method getDefinePackageMethod() {
        Method method = ClassUtil.getDeclaredMethod(ClassLoader.class, "definePackage", new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class});
        method.setAccessible(true);
        return method;
    }

    public static ClassLoader getClassLoader(Class targetClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader targetClassLoader = targetClass.getClassLoader();
        ClassLoader thisClassLoader = ClassLoaderUtil.class.getClassLoader();
        if (targetClassLoader != null && thisClassLoader != null) {
            if (ClassLoaderUtil.isAncestor(thisClassLoader, targetClassLoader)) {
                return thisClassLoader;
            }
            return targetClassLoader;
        }
        if (targetClassLoader != null) {
            return targetClassLoader;
        }
        if (thisClassLoader != null) {
            return thisClassLoader;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader != null) {
            return systemClassLoader;
        }
        throw new IllegalStateException(MessageFormatter.getMessage("ESSR0001", new Object[]{"ClassLoader"}));
    }

    public static Iterator getResources(String name) {
        return ClassLoaderUtil.getResources(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Iterator getResources(Class targetClass, String name) {
        return ClassLoaderUtil.getResources(ClassLoaderUtil.getClassLoader(targetClass), name);
    }

    public static Iterator getResources(ClassLoader loader, String name) {
        try {
            Enumeration<URL> e = loader.getResources(name);
            return new EnumerationIterator(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static boolean isAncestor(ClassLoader cl, ClassLoader other) {
        while (cl != null) {
            if (cl == other) {
                return true;
            }
            cl = cl.getParent();
        }
        return false;
    }

    public static Class findLoadedClass(ClassLoader classLoader, String className) {
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            Class clazz = (Class)MethodUtil.invoke(findLoadedClassMethod, loader, new Object[]{className});
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static Class defineClass(ClassLoader classLoader, String className, byte[] bytes, int offset, int length) {
        return (Class)MethodUtil.invoke(defineClassMethod, classLoader, new Object[]{className, bytes, new Integer(offset), new Integer(length)});
    }

    public static Package definePackage(ClassLoader classLoader, String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        return (Package)MethodUtil.invoke(definePackageMethod, classLoader, new Object[]{name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase});
    }

    public static Class loadClass(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }
}

