/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.meta.impl;

import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.dxo.builder.DxoCommandBuilder;
import org.seasar.extension.dxo.meta.DxoMetadata;
import org.seasar.extension.dxo.meta.DxoMetadataFactory;
import org.seasar.extension.dxo.meta.impl.DxoMetadataImpl;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class DxoMetadataFactoryImpl
implements DxoMetadataFactory,
Disposable {
    protected boolean initialized;
    protected DxoCommandBuilder[] builders;
    protected final Map metadataCache = new HashMap();

    public DxoMetadataFactoryImpl() {
        this.initialize();
    }

    public void setBuilders(DxoCommandBuilder[] builders) {
        this.builders = builders;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        DisposableUtil.add((Disposable)this);
        this.initialized = true;
    }

    public void dispose() {
        this.metadataCache.clear();
        this.initialized = false;
    }

    public DxoMetadata getMetadata(Class dxoClass) {
        this.initialize();
        DxoMetadata metadata = (DxoMetadata)this.metadataCache.get(dxoClass);
        if (metadata != null) {
            return metadata;
        }
        return this.createMetadata(dxoClass);
    }

    protected DxoMetadata createMetadata(Class dxoClass) {
        DxoMetadataImpl metadata = new DxoMetadataImpl(dxoClass, this.builders);
        this.metadataCache.put(dxoClass, metadata);
        return metadata;
    }
}

