#include "TestBoard.h"
#include "../QtBoard/Board.h"
#include <QTest>
#include <QDebug>
#include <time.h>

TestBoard::TestBoard(QObject *parent)
	: QObject(parent)
{

}

TestBoard::~TestBoard()
{

}
void TestBoard::testBoard()
{
	Board bd("G B2  W3    B3W3    B3  W2 G");	//	
	qDebug() << bd.position();
	QCOMPARE( bd.position(), QString("G B2 .W3 . .B3W3 . .B3 .W2 G") );

	bd.setPosition("G B1  W3B1  B3W3    B3  W2 G");
	QCOMPARE( bd.position(), QString("G B1 .W3B1 .B3W3 . .B3 .W2 G") );
	QVERIFY( !bd.doesBlackWin() );
	QVERIFY( !bd.doesWhiteWin() );
	QVERIFY( !bd.canBlackBearOff() );
	QVERIFY( !bd.canWhiteBearOff() );
	QCOMPARE( bd.nBlackGoal(), 0 );
	QCOMPARE( bd.nWhiteGoal(), 0 );
	QCOMPARE( bd.blackTailIndex(), POINT_START - 1 );
	QCOMPARE( bd.whiteTailIndex(), POINT_START - 1 );

	bd.setPosition("G     W3      W3    B3  W2 G");
	QVERIFY( !bd.doesBlackWin() );
	QVERIFY( !bd.doesWhiteWin() );
	QVERIFY( bd.canBlackBearOff() );
	QVERIFY( !bd.canWhiteBearOff() );
	QCOMPARE( bd.nBlackGoal(), 5 );
	QCOMPARE( bd.nWhiteGoal(), 0 );
	QCOMPARE( bd.blackTailIndex(), POINT_GOAL + 3 );
	QCOMPARE( bd.whiteTailIndex(), POINT_START - 1 );

	bd.setPosition("G . . W3. . . . . B3. . .  G");
	QVERIFY( !bd.canBlackBearOff() );
	QVERIFY( bd.canWhiteBearOff() );
}
void TestBoard::testMove()
{
	Board bd("G B2  W3    B3W3    B3  W2 G");	//	
	bd.moveBlack(Move(12, 1));		//	12|Cg̍ЂƂړ
	QCOMPARE( bd.position(), QString("G B1B1W3 . .B3W3 . .B3 .W2 G") );
	bd.moveWhite(Move(reverseIX(10), 2));		//	10|Cg̔12|Cg̍qbg
	QCOMPARE( bd.position(), QString("B1W1B1W2 . .B3W3 . .B3 .W2 G") );
}
//	\擾eXg
void TestBoard::testGetMoves()
{
	Board bd("G B2  W3    B3W3    B3  W2 G");	//	
	QList<Moves> mvsList = bd.whiteMovesList(3, 3);	//	3-3 ɂ\胊Xg擾
	QCOMPARE( mvsList.size(), 2 );
	mvsList = bd.whiteMovesList(2, 2);
	QCOMPARE( mvsList.size(), 2 );
	mvsList = bd.whiteMovesList(1, 1);
	QCOMPARE( mvsList.size(), 2 );
	mvsList = bd.whiteMovesList(1, 2);	//	1-2 ɂ\胊Xg擾
	QCOMPARE( mvsList.size(), 4 );
	mvsList = bd.whiteMovesList(1, 3);
	QCOMPARE( mvsList.size(), 6 );
	mvsList = bd.whiteMovesList(2, 3);
	QCOMPARE( mvsList.size(), 4 );
}

void TestBoard::benchRandomGame()
{
#ifdef _DEBUG
	const int N_LOOP = 100;
#else
	const int N_LOOP = 1000;
#endif
	int gameCount = 0;
	int turnCount = 0;
	int mvsCount = 0;
	QBENCHMARK_ONCE {
		for(int i = 0; i < N_LOOP; ++i) {
			++gameCount;
			Board bd("G B2  W3    B3W3    B3  W2 G");		//	
			bool blackTurn = true;
			for(bool init = true;;) {
				//qDebug() << bd.position();
				if( blackTurn )
					bd.swapBW();
				int d1, d2;
				do {
					d1 = (qrand() % 6) + 1;
					d2 = (qrand() % 6) + 1;
				} while( init && d1 == d2 );
				init = false;
				QList<QList<Move> > mvsList = bd.whiteMovesList(d1, d2);
				if( !mvsList.isEmpty() ) {
					mvsCount += mvsList.size();
					++turnCount;
					QList<Move> mvs = mvsList[qrand() % mvsList.size()];
					foreach(Move mv, mvs)
						bd.moveWhite(mv);
				}
				if( blackTurn )
					bd.swapBW();
				if( bd.doesBlackWin() || bd.doesWhiteWin() ) break;
				blackTurn = !blackTurn;
			}
		}
	}
	qDebug() << "gameCount = " << gameCount;
	qDebug() << "ave turn count = " << (double)turnCount / gameCount;
	qDebug() << "ave mvs count = " << (double)mvsCount / turnCount;
}
//	]֐eXg
void TestBoard::testEval5()
{
	//	Ԃ̉l 400 ƂĂ
	Board bd("G >2  <3    >3<3    >3  <2 G");	//	
	QVERIFY( bd.eval5() > 0 );		//	Ԃ̕L
	bd.setPosition("G >2<1<1<1  >3<3    >3  <2 G");	//	肩qbg\
	QVERIFY( bd.eval5() < 400 );
	bd.setPosition("G >2  <3    >3<3  >1>1>1<2 G");	//	qbgo
	QVERIFY( bd.eval5() > 400 );
	Board bd1, bd2;
	//               G 121110 9 8 7 6 5 4 3 2 1 G
	bd1.setPosition(">1<1<2<2<2    <1        >7 G");	//	12ubg̏ꍇ
	bd2.setPosition(">1<2<2<2      <2        >7 G");	//	Ci[SăubNĂꍇ
	QVERIFY( bd1.eval5() < bd2.eval5() );
	//               G 121110 9 8 7 6 5 4 3 2 1 G
	//               >1    <3<3<2            >7 G
	bd1.setPosition(">1  <2<2<2<2            >7 G");	//	vCOɐi߂
	bd2.setPosition(">1    <4<4              >7 G");	//	ubNς
	QVERIFY( bd1.eval5() > bd2.eval5() );
}
//	_ vs eval5+1ǂ
void TestBoard::statRollout_Random_Eval5Ply1()
{
	///qsrand((int)time(0));
	double eval;
	int randomWin = 0;
	int eval5Win = 0;
#ifdef _DEBUG
	const int N_LOOP = 50;
#else
	const int N_LOOP = 100;
#endif
	for(int i = 0; i < N_LOOP; ++i) {
		Board bd("G >2  <3    >3<3    >3  <2 G");		//	
		bool randomTurn = !(i & 1);
		for(;;) {
			int d1 = (qrand() % 3) + 1;
			int d2 = (qrand() % 3) + 1;
			if( randomTurn ) {
				bd.swapBW();
				QList<Move> mvs = bd.whiteMovesRandom(d1, d2);
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				bd.swapBW();
				if( bd.doesBlackWin() ) {
					++randomWin;
					break;
				}
			} else {
				QList<Move> mvs = bd.whiteMovesEval5PlyD(1, d1, d2, eval);	//	1ǂ݁{eval5()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				if( bd.doesWhiteWin() ) {
					++eval5Win;
					break;
				}
			}
			randomTurn = !randomTurn;
		}
	}
	qDebug() << "eval5 ply-1 = " << eval5Win << "(" << eval5Win * 100 / (double)N_LOOP << "%)";
	qDebug() << "randomWin = " << randomWin << "(" << randomWin * 100 / (double)N_LOOP << "%)";
}
//	_ vs eval5+3ǂ
void TestBoard::statRollout_Random_Eval5Ply3()
{
	///qsrand((int)time(0));
	double eval;
	int randomWin = 0;
	int eval5Win = 0;
#ifdef _DEBUG
	const int N_LOOP = 10;
#else
	const int N_LOOP = 20;
#endif
	for(int i = 0; i < N_LOOP; ++i) {
		Board bd("G >2  <3    >3<3    >3  <2 G");		//	
		bool randomTurn = !(i & 1);
		for(;;) {
			int d1 = (qrand() % 3) + 1;
			int d2 = (qrand() % 3) + 1;
			if( randomTurn ) {
				bd.swapBW();
				QList<Move> mvs = bd.whiteMovesRandom(d1, d2);
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				bd.swapBW();
				if( bd.doesBlackWin() ) {
					++randomWin;
					break;
				}
			} else {
				QList<Move> mvs = bd.whiteMovesEval5PlyD(3, d1, d2, eval);	//	3ǂ݁{eval5()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				if( bd.doesWhiteWin() ) {
					++eval5Win;
					break;
				}
			}
			randomTurn = !randomTurn;
		}
	}
	qDebug() << "eval5 ply-3 = " << eval5Win << "(" << eval5Win * 100 / (double)N_LOOP << "%)";
	qDebug() << "randomWin = " << randomWin << "(" << randomWin * 100 / (double)N_LOOP << "%)";
}
//	eval5+1ǂvs eval5+3ǂ
void TestBoard::statRollout_Eval5Ply1_Eval5Ply3()
{
	///qsrand((int)time(0));
	double eval;
	int eval5Ply1Win = 0;
	int eval5Ply3Win = 0;
#ifdef _DEBUG
	const int N_LOOP = 10;
#else
	const int N_LOOP = 20;
#endif
	for(int i = 0; i < N_LOOP; ++i) {
		Board bd("G >2  <3    >3<3    >3  <2 G");		//	
		bool randomTurn = !(i & 1);
		for(;;) {
			int d1 = (qrand() % 3) + 1;
			int d2 = (qrand() % 3) + 1;
			if( randomTurn ) {
				bd.swapBW();
				QList<Move> mvs = bd.whiteMovesEval5PlyD(1, d1, d2, eval);	//	1ǂ݁{eval5()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				bd.swapBW();
				if( bd.doesBlackWin() ) {
					++eval5Ply1Win;
					break;
				}
			} else {
				QList<Move> mvs = bd.whiteMovesEval5PlyD(3, d1, d2, eval);	//	3ǂ݁{eval5()
				foreach(Move mv, mvs)
					bd.moveWhite(mv);
				if( bd.doesWhiteWin() ) {
					++eval5Ply3Win;
					break;
				}
			}
			randomTurn = !randomTurn;
		}
	}
	qDebug() << "eval5 ply-1 = " << eval5Ply1Win << "(" << eval5Ply1Win * 100 / (double)N_LOOP << "%)";
	qDebug() << "eval5 ply-3 = " << eval5Ply3Win << "(" << eval5Ply3Win * 100 / (double)N_LOOP << "%)";
}
void TestBoard::benchEval5Play1()
{
	double eval;
	QBENCHMARK {
		Board bd("G >2  <3    >3<3    >3  <2 G");		//	
		int d1 = (qrand() % 3) + 1;
		int d2 = (qrand() % 3) + 1;
		QList<Move> mvs = bd.whiteMovesEval5PlyD(1, d1, d2, eval);	//	1ǂ݁{eval5()
	}
}
void TestBoard::benchEval5Play2()
{
	double eval;
	QBENCHMARK {
		Board bd("G >2  <3    >3<3    >3  <2 G");		//	
		int d1 = 2;	//(qrand() % 3) + 1;
		int d2 = 3;	//(qrand() % 3) + 1;
		QList<Move> mvs = bd.whiteMovesEval5PlyD(2, d1, d2, eval);	//	2ǂ݁{eval5()
	}
}
void TestBoard::benchEval5Play3()
{
	double eval;
	QBENCHMARK {
		Board bd("G >2  <3    >3<3    >3  <2 G");		//	
		int d1 = 2;	//(qrand() % 3) + 1;
		int d2 = 3;	//(qrand() % 3) + 1;
		QList<Move> mvs = bd.whiteMovesEval5PlyD(3, d1, d2, eval);	//	3ǂ݁{eval5()
	}
}
