//----------------------------------------------------------------------
//
//			File:			"MainWindow.cpp"
//			Created:		26-Aug-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	HalfGammon ̃CZX CDDL 1.0 łB
	http://opensource.org/licenses/cddl-1.0
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	\[XR[h𗬗pꍇApt@C̃CZX CDDL 1.0 ƂȂ܂B
	p̒쌠 HalfGammon ̂̂܂܂łB
	҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	CDDL 1.0 I܂B̃CZXGPLnėp₷AGPLnƂ͖郉CZXȂ̂ŁA
	HalfGammon ̃\[XGPLnvWFNgŎgp邱Ƃ͂ł܂B

*/

#include <QtGui>
#include <QtNetwork>
#include <time.h>
#include "mainwindow.h"
#include "../QtBoard/Board.h"
#include "TreeSearch.h"
#include "NewGameDlg.h"
#include "SettingsDlg.h"
//#include "InformationDlg.h"

#define		VERSION_STR		"0.009.Dev"
#define		URL_INFO		"http://vivi.dyndns.org/games/HalfGammon/info.txt"
#define		FPS				50

#define		SAME_DICE_SEQ		0		//	eXgpɃTCR̖ڂŒ
#define		MULTI_THREAD		1		//	ǂ݂}`Xbhōs

#define		DST_MARK_MARGIN	(CELL_WD/3)
#define		DST_MARK_WD		(CELL_WD - CELL_WD*2/3)
#define		SEL_MARK_MARGIN	(CELL_WD/16)
#define		SEL_MARK_WD		(CELL_WD/16)
#define		SEL_MARK_LENGTH	(CELL_WD*3/16)

enum {
	GM_HUMAN_VS_COMP = 0,
	GM_COMP_VS_COMP,
};

MainWindow::MainWindow(QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
#if	!SAME_DICE_SEQ
	qsrand((int)time(0));
#endif
	ui.setupUi(this);
	ui.mainToolBar->setWindowTitle("MainToolBar");
	ui.mainToolBar->setObjectName("MainToolBar");
	createDockWindows();
	setWindowTitle(QString("HalfGammon version %1").arg(VERSION_STR));
	resize(900, 700);
#if 0
	QRect geo = geometry();
	geo.setWidth(900);
	geo.setHeight(700);
	setGeometry(geo);
#endif
	readSettings();
	m_firstMoveBlack = true;
	//m_hit = false;
	m_turn = 0;
	m_nextItem = 0;
	m_movingProgress = -1;
	m_view = new QGraphicsView(m_scene = new QGraphicsScene());
	m_view->setRenderHint(QPainter::Antialiasing);
	m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	m_view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	setCentralWidget(m_view);
	setupBoardItems();
	m_treeSearch = new TreeSearch;
	m_thread = new QThread;
#if		MULTI_THREAD
	m_treeSearch->moveToThread(m_thread);
#endif
	connect(m_treeSearch, SIGNAL(searchFinished(double)), this, SLOT(onSearchFinished(double)));
	m_thread->start();


	//	             
	//	E EEEEE
	//	E EEEEE
	//      22     33ubN
	m_board = new Board("G B2  W3    B3W3    B3  W2 G");	//	
	placePieces();
	m_gameState = GS_INIT;
	//newGame();

	m_timer = new QTimer();
	connect(m_timer, SIGNAL(timeout()), this, SLOT(onTimer()));
	m_timer->start(1000/FPS);		//	50fps

	m_networkAccessManager = new QNetworkAccessManager(this);
	connect(m_networkAccessManager, SIGNAL(finished(QNetworkReply*)),
			this, SLOT(replyFinished(QNetworkReply*)));
	QString infoURL = QString("%1?from=%2").arg(URL_INFO).arg(VERSION_STR);
	m_networkAccessManager->get(QNetworkRequest(QUrl(infoURL)));
}
void MainWindow::on_action_NewGame_triggered()
{
	//QMessageBox mb;
	//mb.exec();

	if( m_gameState != GS_INIT ) return;
	//	undone: ߂
	NewGameDlg aDlg;
	aDlg.setGameMode(m_gameMode);
	aDlg.setCompType(m_compType);
	aDlg.setComp2Type(m_comp2Type);
	if( aDlg.exec() == QDialog::Accepted ) {
		m_gameMode = aDlg.gameMode();
		m_compType = aDlg.compType();
		m_comp2Type = aDlg.comp2Type();
		writeSettings();
		newGame();
	}
}
void MainWindow::on_action_Undo_triggered()
{
	if( m_gameState != GS_WAIT_FOR_DECIDED
		&& m_gameState != GS_HUMAN_SRC
		&& m_gameState != GS_HUMAN_DST 
		|| m_boardHist.isEmpty() )
	{
		return;
	}
	*m_board = m_boardHist.last();
	m_boardHist.pop_back();
	addDice(m_diceHist.last());
	m_diceHist.pop_back();
	m_gameState = GS_INIT_HUMAN_SRC;
	placePieces();
	updateDiceItems();
}
void MainWindow::sound(const QString &path)
{
	if( !ui.action_Voice->isChecked() ) return;
#ifdef		_DEBUG
	QString soundPath = "C:/user/Niko2Gammon/dist";
#else
	QString soundPath = qApp->applicationDirPath();
#endif
	soundPath += "/sound/" + path;
	QDir soundDir(soundPath);
	QStringList filter; filter << "*.wav";
	QStringList lst = soundDir.entryList(filter);
	if( lst.isEmpty() ) return;
	int r = qrand() % lst.size();    //  Đt@C_ɑI
	QString wavFile = soundDir.absolutePath() + "/" + lst[r];
	QSound s(wavFile);
	s.play();
}
void MainWindow::newGame()
{
	sound("gameStart");
	//QDialog aDlg;
	//aDlg.exec();
	//QMessageBox::information(this, "test", "test");		//	bZ[W{bNXoƉĐ~܂݂
	m_board->setPosition("G >2. <3. . >3<3. . >3. <2 G");
	//m_board->setPosition("G                   >1<1>1 G");
	//m_board->setPosition(">2. . <3. . >3<3. . >3. <2 G");
	//m_board->setPosition(/*b=*/0x00200030003000, /*w=*/0x00030003000110);
	//m_board->setPosition(/*b=*/0x0000000033000, /*w=*/0x30000000000);
	//	                      
	//	EEEEEE
	//	EEEE 
	//  PQRSTUVWX101112
	//m_board->setPosition(/*b=*/0x00000101022200, /*w=*/0x00220000000030, 0, /*bw=*/1);
	placePieces();
	m_gameState = m_nextGameState = GS_INIT;
	m_blackTurn = m_firstMoveBlack ? 1 : -1;	//	for BLACK
	m_firstMoveBlack = !m_firstMoveBlack;
	m_turn = 1;
	//m_blackTurn = -1;	//	for WWHITE
	updateNextItem();

	m_blackNameTextItem->setText( m_gameMode == GM_HUMAN_VS_COMP ? "human" : "computer-2");
	m_blackNameTextItem->setPos(PIP_X - CELL_WD/2 - 8 - m_blackNameTextItem->boundingRect().width(), PIP_Y);

	if( m_gameMode == GM_HUMAN_VS_COMP && isBlackTurn() )
		m_gameState = GS_INIT_ROLLING_DICE;
	else
		m_gameState = GS_INIT_COMP_TURN;
}
void MainWindow::createDockWindows()
{
	QDockWidget *dock;
	dock = new QDockWidget(tr("Output"));
	dock->setWidget(m_output = new QPlainTextEdit());
	m_output->setFont(QFont("Courier New", 12));
	m_output->setReadOnly(true);
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	addDockWidget(Qt::BottomDockWidgetArea, dock);
	setDockOptions( /*AnimatedDocks |*/ AllowTabbedDocks );
}
void MainWindow::replyFinished(QNetworkReply* reply)
{
	if( reply->error() == QNetworkReply::NoError ) {
		QTextCodec *codec = QTextCodec::codecForName("UTF-8");
		QString buffer = codec->toUnicode(reply->readAll());
		doOutput(buffer);
	} else {
		///doOutput(reply->errorString());
	}
}
void MainWindow::doOutput(const QString &text)
{
#if 1
	QTextCursor cur = m_output->textCursor();
	cur.movePosition(QTextCursor::End);		//	ɃJ[\ړ
	m_output->setTextCursor(cur);
	cur.insertText(text);
#endif
}
void MainWindow::setupBoardItems()
{
	//	_CX
	m_scene->addRect(DICE_X, DICE_Y, DICE_WD, DICE_WD);
	m_scene->addRect(DICE_X + CELL_WD, DICE_Y, DICE_WD, DICE_WD);
	//m_scene->addRect(DICE_X + CELL_WD * 2, DICE_Y, DICE_WD, DICE_WD);
	//m_scene->addRect(DICE_X + CELL_WD * 3, DICE_Y, DICE_WD, DICE_WD);
	QFont font("Arial Black", 28, QFont::Bold);
	m_diceItems << m_scene->addSimpleText("1", font);
	m_diceItems << m_scene->addSimpleText("1", font);
	//m_diceItems << m_scene->addSimpleText("1", font);
	//m_diceItems << m_scene->addSimpleText("1", font);
	const qreal margin = (DICE_WD - m_diceItems[0]->boundingRect().width()) / 2;
	m_diceItems[0]->setPos(DICE_X + margin, DICE_NUM_Y);
	m_diceItems[1]->setPos(DICE_X + CELL_WD + margin, DICE_NUM_Y);
	//m_diceItems[2]->setPos(DICE_X + CELL_WD * 2 + margin, DICE_NUM_Y);
	//m_diceItems[3]->setPos(DICE_X + CELL_WD * 3 + margin, DICE_NUM_Y);

	QFont font2("Arial Black", 12, QFont::Normal);
	//	vC[
	m_blackNameTextItem = m_scene->addSimpleText("human", font2);
	m_blackNameTextItem->setPos(PIP_X - CELL_WD/2 - 8 - m_blackNameTextItem->boundingRect().width(), PIP_Y);
	m_whiteNameTextItem = m_scene->addSimpleText("computer-1", font2);
	m_whiteNameTextItem->setPos(PIP_X - CELL_WD/2 - 8 - m_whiteNameTextItem->boundingRect().width(), PIP_Y2 - 6);
	//	sbvJEg
	const int pipR = CELL_WD / 4;
	m_blackPipsItem = m_scene->addEllipse(PIP_X - CELL_WD/2, PIP_Y + 6, pipR, pipR, QPen(Qt::black), m_blackColor);
	m_whitePipsItem = m_scene->addEllipse(PIP_X - CELL_WD/2, PIP_Y2, pipR, pipR, QPen(Qt::black), m_whiteColor);
	m_blackPipsTextItem = m_scene->addSimpleText("pips: 0 (0)", font2);
	m_blackPipsTextItem->setPos(PIP_X, PIP_Y);
	m_whitePipsTextItem = m_scene->addSimpleText("pips: 0 (0)", font2);
	m_whitePipsTextItem->setPos(PIP_X, PIP_Y2 - 6);
	//	Ֆʔwi
	QBrush brush(QColor("lightgray"));
	m_scene->addRect(ORG_X, ORG_Y, CELL_WD * (N_CELL + 2), CELL_HT, QPen(Qt::black), brush);
	//m_scene->addRect(ORG_X, ORG_Y, CELL_WD, CELL_HT, QPen(Qt::black), brush);
	//m_scene->addRect(ixToPx(IX_BLACK_GOAL), ORG_Y, CELL_WD, CELL_HT, QPen(Qt::black), brush);
	QFont font3("Arial Black", 12, QFont::Bold);
	QPolygonF plygn;
	plygn << QPointF(0, -1) << QPointF(CELL_WD/2, -CELL_HT) << QPointF(CELL_WD, -1);
	for(int i = POINT_START; i >= POINT_GOAL; --i) {
		int px = pointToPx(i);
		QString label = "S/G";
		if( i != POINT_START && i != POINT_GOAL ) {
			QBrush brush(QColor(!(i & 1) ? "lightyellow" : "burlywood"));
			m_scene->addPolygon(plygn, QPen(Qt::transparent), brush)->setPos(px, ORG_Y + CELL_HT);
			label = QString::number(i);
		}
		QGraphicsSimpleTextItem *t = m_scene->addSimpleText(label, font3);
		t->setPos(px + (CELL_WD - t->boundingRect().width()) / 2, ORG_Y + CELL_HT);
	}
	for(int i = POINT_START - 1; i > POINT_GOAL; i -= N_DICE)
		m_scene->addRect(pointToPx(i), ORG_Y, CELL_WD * N_DICE, CELL_HT,
							QPen(Qt::black), QBrush(Qt::transparent));
}
void MainWindow::clearPieces()
{
	foreach(QGraphicsItem *item, m_pieces) {
		m_scene->removeItem(item);
		delete item;
	}
	m_pieces.clear();
}
void MainWindow::placePieces()
{
	doOutput(QString("%1: %2\n").arg(m_turn).arg(m_board->position()));
	clearPieces();
	const bool canBlackBearOff = m_board->canBlackBearOff();
	const bool canWhiteBearOff = m_board->canWhiteBearOff();
	int nbb = m_board->nBlackBar();
	const int ba = m_board->doesWhiteWin() ? -20 : !nbb ? 20 : 0;
	int nbw = m_board->nWhiteBar();
	const int wa = m_board->doesBlackWin() ? -20 : !nbw ? 20 : 0;
	int bpip = m_board->nBlackBar() * (N_CELL + 1);
	int wpip = m_board->nWhiteBar() * (N_CELL + 1);
	for(int i = POINT_START; i >= POINT_GOAL; --i) {
		int px = pointToPx(i);
		int n = i == POINT_WHITE_GOAL ? -m_board->nWhiteGoal() :
				i == POINT_BLACK_GOAL ? m_board->nBlackGoal() :
										m_board->position(i);
		if( n > 0 )
			bpip += i * n;		//	̓|Cĝ܂܃sbvX
		if( n < 0 )
			wpip += (POINT_START - i) * -n;
		int py = ORG_Y;
		QString mouth;
		if( i == POINT_BLACK_GOAL || i == POINT_WHITE_GOAL )
			mouth = QString(QChar(0x25bd));		//	
		else if( n > 0 && canBlackBearOff || n < 0 && canWhiteBearOff )
			mouth = QString(QChar(0xff5e));		//	"`"
		if( n > 4 ) {
			int step = (PIECE_Y - ORG_Y) / (n - 1);
			do {
				m_pieces << addPiece(px, py, true, ba, mouth);
				py += step;
			} while( --n != 0 );
		} else if( n < -4 ) {
			int step = (PIECE_Y - ORG_Y) / (-n - 1);
			do {
				m_pieces << addPiece(px, py, false, wa, mouth);
				py += step;
			} while( ++n != 0 );
		}
		switch( n ) {
		case 4:
			m_pieces << addPiece(px, PIECE_Y - PIECE_WD * 3, true, ba, mouth);
		case 3:
			m_pieces << addPiece(px, PIECE_Y - PIECE_WD * 2, true, ba, mouth);
		case 2:
			m_pieces << addPiece(px, PIECE_Y - PIECE_WD, true, ba, mouth);
		case 1:
			m_pieces << addPiece(px, PIECE_Y, true, ba, mouth);
			break;
		case -4:
			m_pieces << addPiece(px, PIECE_Y - PIECE_WD * 3, false, wa, mouth);
		case -3:
			m_pieces << addPiece(px, PIECE_Y - PIECE_WD * 2, false, wa, mouth);
		case -2:
			m_pieces << addPiece(px, PIECE_Y - PIECE_WD, false, wa, mouth);
		case -1:
			m_pieces << addPiece(px, PIECE_Y, false, wa, mouth);
			break;
		}
	}
	if( nbb != 0 ) {	//	o[̍
		int px = ORG_X + CELL_WD / 3 * (nbb - 1);
		while( --nbb >= 0 ) {
			m_pieces << addPiece(px, DICE_Y, true, -20);
			px -= CELL_WD / 3;
		}
	}
	if( nbw != 0 ) {	//	o[̔
		int px = ORG_X + CELL_WD * IX_START - CELL_WD / 3 * (nbw - 1);
		while( --nbw >= 0 ) {
			m_pieces << addPiece(px, DICE_Y, false, -20);
			px += CELL_WD / 3;
		}
	}
	//	sbvJEg\
	m_blackPipsTextItem->setText(QString("pips: %1 (%2)").arg(bpip).arg(bpip - wpip));
	m_whitePipsTextItem->setText(QString("pips: %1 (%2)").arg(wpip).arg(wpip - bpip));
}
QGraphicsEllipseItem *MainWindow::addCircle(qreal cx, qreal cy, qreal r,
											const QPen &pen, const QBrush &brush,
											QGraphicsItem *parent)
{
	QGraphicsEllipseItem *i = 
		m_scene->addEllipse(-r, -r, r * 2, r * 2, pen, brush);
	if( parent != 0 )
		i->setParentItem(parent);
	i->setPos(cx, cy);
	return i;
}
void MainWindow::addEyebrow(qreal cx, qreal cy, qreal angle, QGraphicsItem *parent)
{
	QPen pen(Qt::black);
	QBrush brush(Qt::black);
	QGraphicsRectItem *i = 
		m_scene->addRect(-4, -1, 8, 2, pen, brush);
	i->setParentItem(parent);
	i->setPos(cx, cy);
	i->setRotation(angle);
}
QGraphicsItem *MainWindow::addPiece(int px, int py, bool human, int ebAngle, QString mouth)
{
	QBrush brush(human ? m_blackColor : m_whiteColor);
	QPen pen(Qt::black);
	QGraphicsItem *p = addCircle(px + CELL_WD/2, py + CELL_WD/2, PIECE_WD/2, pen, brush);
	//QGraphicsDropShadowEffect *efct = new QGraphicsDropShadowEffect();
	//efct->setXOffset(2);
	//efct->setYOffset(2);
	//efct->setBlurRadius(2);
	//p->setGraphicsEffect(efct);
	//m_pieces << p;
	const qreal EYE_SIZE = (qreal)PIECE_WD / 6;
	const qreal EYE_SPACE = (qreal)PIECE_WD / 8;
	const qreal EYE_PY = -(qreal)PIECE_WD / 8;
	qreal cx = (human ? CELL_WD / 16 : -CELL_WD /16);
	QGraphicsEllipseItem *i = 0;
	addCircle(cx - EYE_SPACE, EYE_PY, EYE_SIZE/2, QPen(QColor(Qt::black)), QBrush(Qt::black), p);
	addEyebrow(cx - EYE_SPACE, EYE_PY - 8, ebAngle, p);
	addCircle(cx + EYE_SPACE, EYE_PY, EYE_SIZE/2, QPen(QColor(Qt::black)), QBrush(Qt::black), p);
	addEyebrow(cx + EYE_SPACE, EYE_PY - 8, -ebAngle, p);

	if( !mouth.isEmpty() ) {
		QGraphicsSimpleTextItem *m = new QGraphicsSimpleTextItem(mouth, p);
		m->setPos(cx - m->boundingRect().width() / 2, 0);
		m->setFont(QFont("Arial Black", 10, QFont::Normal));
	}
	return p;
}
QGraphicsItem *MainWindow::findPiece(int point)
{
	int cx = ORG_X + (POINT_START - point) * CELL_WD + CELL_WD / 2;
	int cy = ORG_Y + CELL_HT - CELL_WD / 2;
	return findPiece(cx, cy);
}
QGraphicsItem *MainWindow::findPiece(int cx, int cy)
{
	foreach(QGraphicsItem *item, m_pieces) {
		QRectF br = item->boundingRect();
		QRectF r(br.topLeft() + item->pos(), br.bottomRight() + item->pos());
		if( r.contains(QPointF(cx, cy)) )
			return item;
		//if( item->mapToScene(item->boundingRect()).contains(QPointF(cx, cy)) )
		//	return item;
	}
	return 0;
}
void MainWindow::updateNextItem()
{
	if( m_nextItem != 0 ) {
		m_scene->removeItem(m_nextItem);
		delete m_nextItem;
	}
#if 0
	QFont font("Arial Black", 12, QFont::Normal);
	m_nextItem = m_scene->addSimpleText(tr("next:"), font);
	int py = isBlackTurn() ? PIP_Y : PIP_Y2 - 6;
	m_nextItem->setPos(DICE_X + CELL_WD * 2 + 8, py);
#else
	m_nextItem = addPiece(DICE_X + CELL_WD * 2, DICE_Y - PIECE_MARGIN, isBlackTurn());
#endif
}
MainWindow::~MainWindow()
{

}
//	return:
//		true for ^[~lCg
//		false for ^[~lCgs
bool MainWindow::confirmToTerminate()
{
	if( m_gameState == GS_INIT || m_gameMode != GM_HUMAN_VS_COMP )
		return true;
	if( QMessageBox::question(this, "Dodgem Game",
								tr("Are you sure to terminate this game ?\n") +
								tr("This game will be regarded as a defeat."),
							QMessageBox::Yes | QMessageBox::No)
			!= QMessageBox::Yes )
	{
		return false;
	}
	return true;
}
void MainWindow::closeEvent(QCloseEvent *event)
{
	writeSettings();
	if( !confirmToTerminate() )
		event->ignore();
	else {
		//writeSettings();
		//QMainWindow::closeEvent(event);
		doExit();
	}
}
void MainWindow::on_action_Exit_triggered()
{
	if( !confirmToTerminate() )
		return;
	//m_gameCountList[m_gameBoardTypeIx] += 1;
	//writeIntList("gameCountList", m_gameCountList);
	doExit();
}
void MainWindow::doExit()
{
	if( m_gameState != GS_INIT && m_gameMode == GM_HUMAN_VS_COMP ) {
		++m_humanStat.m_gameCount;
		++m_compStat[m_compType].m_gameCount;
		++m_compStat[m_compType].m_winCount;
		writeSettings();
	}
	qApp->quit();
}
void MainWindow::keyPressEvent ( QKeyEvent * e )
{
	if( e->key() == Qt::Key_Escape ) {
		m_gameState = GS_INIT;
		return;
	}
}
void MainWindow::readSettings()
{
	QSettings settings;
	restoreGeometry(settings.value("geometry").toByteArray());
	restoreState(settings.value("windowState").toByteArray());
	ui.action_Voice->setChecked(settings.value("voice", true).toBool());
	m_undoAvailable = settings.value("undo", false).toBool();
	m_gameMode = settings.value("gameMode", 0).toInt();
	m_compType = settings.value("compType", 0).toInt();
	m_comp2Type = settings.value("comp2Type", 0).toInt();
	m_autoMoveDst = settings.value("autoMoveDst", false).toBool();
	m_humanStat.m_winCount = settings.value("winCount", 0).toInt();
	m_humanStat.m_gameCount = settings.value("gameCount", 0).toInt();
	m_humanStat.m_rating = settings.value("humanRating", 1500).toInt();
	for(int i = 0; i < N_LEVEL; ++i) {
		m_compStat[i].m_winCount = settings.value(QString("compWinCount-%1").arg(i+1), 0).toInt();
		m_compStat[i].m_gameCount = settings.value(QString("compGameCount-%1").arg(i+1), 0).toInt();
		m_compStat[i].m_rating = settings.value(QString("compRating-%1").arg(i+1), 1500).toInt();
	}
	m_animationSpeed = settings.value("animationSpeed", 2).toInt();
	m_blackColorText = settings.value("blackColor", "greenyellow").toString();
	m_whiteColorText = settings.value("whiteColor", "white").toString();
	m_blackColor = QColor(m_blackColorText);
	m_whiteColor = QColor(m_whiteColorText);
}
void MainWindow::writeSettings()
{
	QSettings settings;
	settings.setValue("geometry", saveGeometry());
	settings.setValue("windowState", saveState());
	settings.setValue("voice", ui.action_Voice->isChecked());
	settings.setValue("gameMode", m_gameMode);
	settings.setValue("compType", m_compType);
	settings.setValue("comp2Type", m_comp2Type);
	settings.setValue("undo", m_undoAvailable);
	settings.setValue("autoMoveDst", m_autoMoveDst);
	settings.setValue("winCount", m_humanStat.m_winCount);
	settings.setValue("gameCount", m_humanStat.m_gameCount);
	settings.setValue("humanRating", m_humanStat.m_rating);
	for(int i = 0; i < N_LEVEL; ++i) {
		settings.setValue(QString("compWinCount-%1").arg(i+1), m_compStat[i].m_winCount);
		settings.setValue(QString("compGameCount-%1").arg(i+1), m_compStat[i].m_gameCount);
		settings.setValue(QString("compRating-%1").arg(i+1), m_compStat[i].m_rating);
	}
	settings.setValue("animationSpeed", m_animationSpeed);
	settings.setValue("blackColor", m_blackColorText);
	settings.setValue("whiteColor", m_whiteColorText);
}
void MainWindow::onSearchFinished(double eval)
{
	doOutput(QString("eval = %1\n").arg(eval));
	m_compMove = m_treeSearch->m_mvs;
	foreach(Move mv, m_compMove)
		doOutput(QString("  move src = %1 d = %2\n").arg((int)mv.m_src).arg((int)mv.m_d));
	if( m_compMove.isEmpty() ) {
		if( m_gameMode == GM_HUMAN_VS_COMP )
			QMessageBox::information(this, "HalfGammon", tr("I can't move."));
		m_blackTurn = -m_blackTurn;
		++m_turn;
		updateNextItem();
		if( m_gameMode == GM_HUMAN_VS_COMP && isBlackTurn() )
			m_gameState = GS_INIT_ROLLING_DICE;
		else
			m_gameState = GS_INIT_COMP_TURN;
	} else
		m_gameState = GS_COMP_TURN;
}
//	m_dstList ̓eЂƂH
bool MainWindow::isForcedMoveDest() const
{
	if( m_dstList.size() == 1 ) return true;
	if( m_dstList.size() != 2 ) return false;
	return m_dstList[0] <= POINT_BLACK_GOAL
			&& m_dstList[1] <= POINT_BLACK_GOAL;
}
void MainWindow::onTimer()
{
	static int count = 0;
	switch( m_gameState ) {
	case GS_INIT_ROLLING_DICE:
		m_boardHist.clear();
		m_diceHist.clear();
		updateDice();
		count = 0;
		statusBar()->showMessage(tr("click to stop rolling dice."), 5000);
		//doOutput("rolling dice...\n");
		m_rollDiceTime = QTime::currentTime();
		m_gameState = GS_ROLLING_DICE;
		break;
	case GS_ROLLING_DICE:
#if	SAME_DICE_SEQ
		m_dice[0] = 2;
		m_dice[1] = 3;
		m_dice[2] = 0;
		m_dice[3] = 0;
		updateDiceItems();
		statusBar()->showMessage("");
		m_gameState = GS_INIT_HUMAN_SRC;
#else
		if( ++count < 4 ) break;
		count = 0;
		updateDice();
		if( m_rollDiceTime.secsTo(QTime::currentTime()) >= 1 ) {
			statusBar()->showMessage("");
			m_gameState = GS_INIT_HUMAN_SRC;
		}
#endif
		break;
	case GS_INIT_HUMAN_SRC:		//	ړΑI҂ 
		doOutput(QString("d1 = %1 d2 = %2\n").arg(m_dice[0]).arg(m_dice[1]));
		setupSrcMarks();
		if( !isPossibleToMove() ) {	//	ړ\肪ꍇ
L01:
			if( m_gameMode == GM_HUMAN_VS_COMP )
				QMessageBox::information(this, "HalfGammon", tr("impossible to move."));
			m_gameState = GS_INIT_ROLLING_DICE;
			m_blackTurn = -m_blackTurn;
			++m_turn;
			updateNextItem();
			if( m_gameMode == GM_HUMAN_VS_COMP && isBlackTurn() )
				m_gameState = GS_INIT_ROLLING_DICE;
			else
				m_gameState = GS_INIT_COMP_TURN;
			return;
		}
		if( m_board->nBlackBar() ) {
			m_srcPoint = POINT_BLACK_START;
			setDstMarks(POINT_BLACK_START);
			m_gameState = GS_HUMAN_DST;
		} else {
			QList<Move> lst = m_board->blackMoves(m_dice[0], m_dice[1]);
			if( lst.isEmpty() )
				goto L01;	//	ړs\ȏꍇ
			m_gameState = GS_HUMAN_SRC;
		}
		break;
	case GS_HUMAN_DST:
		if( m_autoMoveDst && isForcedMoveDest() ) {
			m_dstPoint = m_dstList[0];
			Q_ASSERT( m_dstPoint < N_CELL + 2 );
			m_d = m_dList[0];
			clearDstMarks();
			clearSrcMarks();
			m_movingHumanPiece = true;
			if( isBlackTurn() && m_dstPoint != POINT_BLACK_GOAL && m_board->white(reverseIX(m_dstPoint)) == 1
				|| !isBlackTurn() && m_dstPoint != POINT_WHITE_GOAL && m_board->black(m_dstPoint) == 1 )
			{
				m_hitItem = findPiece(m_dstPoint);
			} else {
				m_hitItem = 0;
			}
			m_gameState = GS_INIT_MOVING_PIECE;
		}
		break;
	case GS_INIT_COMP_TURN:
		if( 1 )
			updateDice();
		else {
			m_dice[0] = 2;
			m_dice[1] = 3;
			m_dice[2] = 0;
			m_dice[3] = 0;
		}
		updateDiceItems();
		doOutput(QString("d1 = %1, d2 = %2\n").arg(m_dice[0]).arg(m_dice[1]));
		m_treeSearch->setBoard(*m_board);
		m_treeSearch->m_blackTurn = isBlackTurn();
		m_treeSearch->m_searchType = isBlackTurn() ? m_comp2Type : m_compType;
		m_treeSearch->m_d1 = m_dice[0];
		m_treeSearch->m_d2 = m_dice[1];
		QMetaObject::invokeMethod(m_treeSearch, "doSearch", Qt::QueuedConnection);
		m_gameState = GS_COMP_SEARCHING;
		break;
	case GS_COMP_TURN: {
		if( m_compMove.isEmpty() ) {	//	Rs[^I
			m_blackTurn = -m_blackTurn;
			++m_turn;
			updateNextItem();
			if( m_gameMode == GM_HUMAN_VS_COMP )
				m_gameState = GS_INIT_ROLLING_DICE;
			else
				m_gameState = GS_INIT_COMP_TURN;
			break;
		}
		Move mv = m_compMove[0];
		m_compMove.pop_front();
		m_d = mv.m_d;
		m_srcPoint = mv.m_src;
		m_dstPoint = qMax(m_srcPoint - m_d, (int)POINT_BLACK_GOAL);
		if( !isBlackTurn() ) {
			m_srcPoint = reverseIX(m_srcPoint);	//	MainWindow ł͏ɍ΍Wn
			m_dstPoint = reverseIX(m_dstPoint);
		}
		Q_ASSERT( m_dstPoint < N_CELL + 2 );
		m_movingHumanPiece = false;
		if( isBlackTurn() && m_dstPoint != POINT_BLACK_GOAL && m_board->white(reverseIX(m_dstPoint)) == 1
			|| !isBlackTurn() && m_dstPoint != POINT_WHITE_GOAL && m_board->black(m_dstPoint) == 1 )
		{
			m_hitItem = findPiece(m_dstPoint);
		} else {
			m_hitItem = 0;
		}
		m_gameState = GS_INIT_MOVING_PIECE;
		break;
	}
	case GS_INIT_MOVING_PIECE:
		doOutput(QString("%1 moves %2 to %3\n")
					.arg(isBlackTurn() ? "black" : "white")
					.arg(m_srcPoint).arg(m_dstPoint));
		indexToXY(m_srcPoint, m_srcPx, m_srcPy);
		m_srcPx += CELL_WD/2;
		if( m_srcPoint == POINT_BLACK_START || m_srcPoint == POINT_WHITE_START )
			m_srcPy = DICE_Y + CELL_WD/2;
		else
			m_srcPy += CELL_HT - CELL_WD/2;
		indexToXY(m_dstPoint, m_dstPx, m_dstPy);
		m_dstPx += CELL_WD/2;
		Q_ASSERT( m_dstPx < ORG_X + CELL_WD * (N_CELL + 2) );
		m_dstPy += CELL_HT - CELL_WD/2;
		m_movingItem = findPiece(m_srcPx, m_srcPy);
		if( m_movingItem == 0 ) {
			//	ɂ͗Ȃ͂
			m_gameState = GS_INIT;
			return;
		}
		m_movingItem->setZValue(5);
		m_movingProgress = 0;
		m_gameState = GS_MOVING_PIECE;
		break;
	case GS_MOVING_PIECE:
		if( m_movingProgress >= 0 && m_movingItem != 0 ) {
			int px = m_srcPx + (m_dstPx - m_srcPx) * m_movingProgress / 100;
			int py = m_srcPy + (m_dstPy - m_srcPy) * m_movingProgress / 100;
			Q_ASSERT( px < ORG_X + CELL_WD * (N_CELL + 2) );
			m_movingItem->setPos(px, py);
			if( m_movingProgress >= 100 ) {		//	ړI
				m_gameState = GS_MOVING_PIECE_FINISHED;
			} else
				m_movingProgress += m_animationSpeed;
		} else {
			//	ɂ͗Ȃ͂
			m_gameState = GS_INIT;
			return;
		}
		break;
	case GS_MOVING_PIECE_FINISHED: {
		m_movingItem->setZValue(0);
		if( m_hitItem != 0 ) {
			if( m_gameMode == GM_HUMAN_VS_COMP ) {
				if( isBlackTurn() )
					sound("humanHitComp");
				else
					sound("compHitHuman");
			}
			m_movingItem = m_hitItem;
			m_movingItem->setZValue(5);
			m_hitItem = 0;
			m_movingProgress = 0;
			//m_srcPoint = m_dstPoint;
			m_srcPx = m_dstPx;
			m_srcPy = m_dstPy;
			int dst = isBlackTurn() ? POINT_WHITE_START : POINT_BLACK_START;
			m_dstPx = ORG_X + (IX_START - dst) * CELL_WD + CELL_WD / 2;
			m_dstPy = DICE_Y + CELL_WD / 2;
			m_gameState = GS_MOVING_PIECE;
			break;
		}
		m_movingItem = 0;
		m_movingProgress = -1;
		QString mess;
		int hr = m_humanStat.m_rating;
		m_boardHist << *m_board;
		if( isBlackTurn() ) {
			m_board->moveBlack(m_srcPoint, m_dstPoint);
			if( m_board->doesBlackWin() ) {
				if( m_gameMode == GM_HUMAN_VS_COMP ) {
					sound("humanWin");
					++m_humanStat.m_winCount;
					updateRating(m_humanStat.m_rating, m_compStat[m_compType].m_rating);
					if( m_board->doesWhiteBackGammonLose() )
						mess = tr("You backgammoned Win");
					else if( m_board->doesWhiteGammonLose() )
						mess = tr("You gammoned Win");
					else
						mess = tr("You Win.");
				} else {
					++m_compStat[m_comp2Type].m_winCount;
					if( m_compType != m_comp2Type )
						updateRating(m_compStat[m_comp2Type].m_rating, m_compStat[m_compType].m_rating);
					if( m_board->doesWhiteBackGammonLose() )
						mess = tr("Computer-2 backgammoned Win");
					else if( m_board->doesWhiteGammonLose() )
						mess = tr("Computer-2 gammoned Win");
					else
						mess = tr("Computer-2 Win");
				}
			}
		} else {
			m_board->moveWhite(reverseIX(m_srcPoint), reverseIX(m_dstPoint));
			if( m_board->doesWhiteWin() ) {
				if( m_gameMode == GM_HUMAN_VS_COMP ) {
					sound("compWin");
					if( m_board->doesBlackBackGammonLose() )
						mess = tr("I backgammoned Win");
					else if( m_board->doesBlackGammonLose() )
						mess = tr("I gammoned Win");
					else
						mess = tr("I Win");
					++m_compStat[m_compType].m_winCount;
					updateRating(m_compStat[m_compType].m_rating, m_humanStat.m_rating);
				} else {
					++m_compStat[m_compType].m_winCount;
					if( m_compType != m_comp2Type )
						updateRating(m_compStat[m_compType].m_rating, m_compStat[m_comp2Type].m_rating);
					if( m_board->doesBlackBackGammonLose() )
						mess = tr("Computer-1 backgammoned Win");
					else if( m_board->doesBlackGammonLose() )
						mess = tr("Computer-1 gammoned Win");
					else
						mess = tr("Computer-1 Win");
				}
			}
		}
		placePieces();
		if( !mess.isEmpty() ) {		//	Q[I[o ̏ꍇ
			m_turn = 0;
			if( m_gameMode == GM_HUMAN_VS_COMP ) {
				++m_humanStat.m_gameCount;
				++m_compStat[m_compType].m_gameCount;
				mess += "\n\n";
				mess += tr("Your Rating = %1 (%2%3 added)\n")
							.arg(m_humanStat.m_rating)
							.arg(m_humanStat.m_rating - hr > 0 ? "+" : "")
							.arg(m_humanStat.m_rating - hr);
				mess += tr("record = %1/%2 (%3%)")
							.arg(m_humanStat.m_winCount)
							.arg(m_humanStat.m_gameCount)
							.arg((double)m_humanStat.m_winCount*100/m_humanStat.m_gameCount);
			} else {
				++m_compStat[m_compType].m_gameCount;
				++m_compStat[m_comp2Type].m_gameCount;
			}
			mess += "\n\n";
			mess += tr("one more the same settings game ?");
			writeSettings();
			QMessageBox aDlg(QMessageBox::NoIcon, "HalfGammon", mess,
								QMessageBox::Yes | QMessageBox::No);
			if( aDlg.exec() == QMessageBox::Yes )
#if 0
			if( QMessageBox::information(this, "HalfGammon", mess,
								QMessageBox::Yes | QMessageBox::No)
				== QMessageBox::Yes )
#endif
			{
				clearPieces();
				newGame();
			} else
				m_gameState = GS_INIT;
			return;
		}
		if( m_movingHumanPiece ) {
			removeDice(m_d);	
			m_diceHist << (int)m_d;
			updateDiceItems();
			if( !m_dice[0] ) {		//	SẴ_CX̖ڂړIꍇ
				if( m_undoAvailable ) {
					statusBar()->showMessage(tr("Click to next turn."));
					m_gameState = GS_WAIT_FOR_DECIDED;
				} else {
					m_blackTurn = -m_blackTurn;
					updateNextItem();
					if( isBlackTurn() )
						m_gameState = GS_INIT_ROLLING_DICE;
					else
						m_gameState = GS_INIT_COMP_TURN;	//	_CXU
				}
			} else {
				if( isBlackTurn() )
					m_gameState = GS_INIT_HUMAN_SRC;
				else
					m_gameState = GS_COMP_TURN;		//	_CXU蒼Ȃ
			}
		} else {
			m_gameState = GS_COMP_TURN;	//	_CXU蒼Ȃ
		}
		break;
	}
	case GS_WAIT_FOR_DECIDED:
		break;
	}
}
void MainWindow::mousePressEvent ( QMouseEvent * event )
{
	QPoint pntG = m_view->mapFromGlobal(event->globalPos());
	QPointF pnt = m_view->mapToScene(pntG);
	int ix = xyToIndex(pnt.x(), pnt.y());
	int i;
	switch( m_gameState ) {
	case GS_WAIT_FOR_DECIDED:
		m_blackTurn = -m_blackTurn;
		updateNextItem();
		if( isBlackTurn() )
			m_gameState = GS_INIT_ROLLING_DICE;
		else
			m_gameState = GS_INIT_COMP_TURN;	//	_CXU
		break;
	case GS_ROLLING_DICE:
		statusBar()->showMessage("");
		m_gameState = GS_INIT_HUMAN_SRC;
		break;
	case GS_HUMAN_SRC:		//	ړΑI҂
		if( ix < POINT_BLACK_START && ix > POINT_GOAL &&		//	o[ɐ΂ꍇ́Aړ΂͊ɑIĂ
			m_board->position(ix) * m_blackTurn > 0 )
		{
			if( !setDstMarks(ix) )
				break;		//	ړs\ȏꍇ
			m_srcPoint = ix;
			m_gameState = GS_HUMAN_DST;
		}
		break;
	case GS_HUMAN_DST:
		if( (i = m_dstList.indexOf(ix)) >= 0 ) {
			m_dstPoint = ix;
			Q_ASSERT( m_dstPoint < N_CELL + 2 );
			m_d = m_dList[i];
			clearDstMarks();
			clearSrcMarks();
			m_movingHumanPiece = true;
			if( isBlackTurn() && m_dstPoint != POINT_BLACK_GOAL && m_board->white(reverseIX(m_dstPoint)) == 1
				|| !isBlackTurn() && m_dstPoint != POINT_WHITE_GOAL && m_board->black(m_dstPoint) == 1 )
			{
				m_hitItem = findPiece(m_dstPoint);
			} else {
				m_hitItem = 0;
			}
			m_gameState = GS_INIT_MOVING_PIECE;
		} else {
			clearDstMarks();
			clearSrcMarks();
			m_gameState = GS_INIT_HUMAN_SRC;
		}
		break;
	}
	//doOutput(QString("black = 0x%1 (%2), white = 0x%3 (%4)\n")
	//						.arg(m_board->black(), 0, 16).arg(m_board->nBlackBar())
	//						.arg(m_board->white(), 0, 16).arg(m_board->nWhiteBar()));
}
//	r1 ꍇ̃[eBOXV
void MainWindow::updateRating(int &r1, int &r2)
{
	int d = (int)(16 + (r2 - r1) * 0.04 + 0.5);
	d = qMax(qMin(d, 31), 1);
	r1 += d;
	r2 -= d;
}
void MainWindow::updateDice()
{
	//	TCR̖ڂ_ɕω
	do {
		QString::number(m_dice[0] = (qrand() % N_DICE) + 1);
		QString::number(m_dice[1] = (qrand() % N_DICE) + 1);
	} while( m_turn == 1 && m_dice[0] == m_dice[1] );
	if( m_dice[0] == m_dice[1] )
		m_dice[3] = m_dice[2] = m_dice[0];
	else
		m_dice[3] = m_dice[2] = 0;
	updateDiceItems();
}
void MainWindow::updateDiceItems()
{
	for(int i = 0; i < 2; ++i)
		m_diceItems[i]->setText( m_dice[i] != 0 ? QString::number(m_dice[i]) : "");
}
//	index ͍CfNXƂ
void MainWindow::indexToXY(int ix, int &px, int &py) const
{
	Q_ASSERT( ix >= 0 && ix < N_CELL + 2 );
	px = ORG_X + reverseIX(ix) * CELL_WD;
	py = ORG_Y;
}
int MainWindow::xyToIndex(int px, int py) const
{
	if( px < ORG_X || px >= ORG_X + CELL_WD * (N_CELL + 2) ||
		py < ORG_Y || py >= ORG_Y + CELL_HT )
	{
		return -1;
	}
	return reverseIX((px - ORG_X) / CELL_WD);
}
//	ړ\Ŗꍇ false Ԃ
bool MainWindow::isPossibleToMove()
{
	if( isBlackTurn() ) {
		QList<Move> lst = m_board->blackMoves(m_dice[0], m_dice[1]);
		if( lst.isEmpty() ) {
			//qDebug() << m_board->position();
			//lst = m_board->blackMoves(m_dice[0], m_dice[1]);	//	for Debug
			return false;
		}
		//if( !m_board->canBlackMove(m_dice[0]) &&
		//		m_dice[1] != 0 && !m_board->canBlackMove(m_dice[1]) )
		//	return false;
		if( m_board->nBlackBar() != 0 ) {
			m_srcPoint = POINT_BLACK_START;
			setDstMarks(POINT_BLACK_START);
			m_gameState = GS_HUMAN_DST;
		}
	} else {
		QList<Move> lst = m_board->whiteMoves(m_dice[0], m_dice[1]);
		if( lst.isEmpty() )
			return false;
		//if( !m_board->canWhiteMove(m_dice[0]) &&
		//		m_dice[1] != 0 && !m_board->canWhiteMove(m_dice[1]) )
		//	return false;
		if( m_board->nWhiteBar() != 0 ) {
			m_srcPoint = POINT_WHITE_START;
			setDstMarks(POINT_WHITE_START);
			m_gameState = GS_HUMAN_DST;
		}
	}
	return true;
}
void MainWindow::addDice(int d)
{
	for(int ix = 0; ix < 4; ++ix) {
		if( !m_dice[ix] ) {
			m_dice[ix] = d;
			return;
		}
	}
}
void MainWindow::removeDice(int d)
{
	int ix = 0;
	while( ix < 4 && m_dice[ix] != d ) ++ix;
	while( ix < 3 ) {
		m_dice[ix] = m_dice[ix + 1];
		++ix;
	}
	m_dice[3] = 0;
}
void MainWindow::clearSrcMarks()
{
	foreach(QGraphicsRectItem *item, m_srcMarks) {
		m_scene->removeItem(item);
		delete item;
	}
	m_srcMarks.clear();
}
void MainWindow::clearDstMarks()
{
	foreach(QGraphicsRectItem *item, m_dstMarks) {
		m_scene->removeItem(item);
		delete item;
	}
	m_dstMarks.clear();
	m_dstList.clear();
	m_dList.clear();
}
//	src == 0 ̏ꍇ́Ão[̈ړ
//	src == POINT_WHITE_START  ̏ꍇ́Ão[̈ړ
bool MainWindow::canMove(int src, int dst) const
{
	if( isBlackTurn() )
		return m_board->canBlackMoveSrcDst(src, dst);
	else
		return m_board->canWhiteMoveSrcDst(reverseIX(src), reverseIX(dst));

}
void MainWindow::setupSrcMarks()
{
	clearSrcMarks();
	if( m_board->black(IX_START) != 0 ) return;	//	o[ɐ΂ꍇ
	for(int src = IX_START - 1; src > IX_GOAL; --src) {
		if( m_board->black(src) != 0 &&
			(canMove(src, src - m_dice[0]) ||
			m_dice[1] != 0 && canMove(src, src - m_dice[1])) )
		{
			setSrcMarks(src, false);
		}
	}
}
void MainWindow::setSrcMarks(int src, bool bClear)
{
	if( bClear )
		clearSrcMarks();
	int px, py;
	indexToXY(src, px, py);
	if( src == POINT_BLACK_START || src == POINT_WHITE_START )
		py -= CELL_WD;
	else
		py = PIECE_Y;
	QGraphicsRectItem *ri;
	//	
	ri = m_scene->addRect(	px + SEL_MARK_MARGIN,
							py + SEL_MARK_MARGIN,
							SEL_MARK_WD,
							SEL_MARK_LENGTH,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	ri = m_scene->addRect(	px + SEL_MARK_MARGIN,
							py + SEL_MARK_MARGIN,
							SEL_MARK_LENGTH,
							SEL_MARK_WD,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	//	
	ri = m_scene->addRect(	px + SEL_MARK_MARGIN,
							py + CELL_WD - SEL_MARK_MARGIN - SEL_MARK_WD,
							SEL_MARK_LENGTH,
							SEL_MARK_WD,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	ri = m_scene->addRect(	px + SEL_MARK_MARGIN,
							py + CELL_WD - SEL_MARK_MARGIN - SEL_MARK_LENGTH,
							SEL_MARK_WD,
							SEL_MARK_LENGTH,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	//	E
	ri = m_scene->addRect(	px + CELL_WD - SEL_MARK_MARGIN - SEL_MARK_WD,
							py + SEL_MARK_MARGIN,
							SEL_MARK_WD,
							SEL_MARK_LENGTH,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	ri = m_scene->addRect(	px + CELL_WD - SEL_MARK_LENGTH - SEL_MARK_MARGIN,
							py + SEL_MARK_MARGIN,
							SEL_MARK_LENGTH,
							SEL_MARK_WD,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	//	E
	ri = m_scene->addRect(	px + CELL_WD - SEL_MARK_MARGIN - SEL_MARK_WD,
							py + CELL_WD - SEL_MARK_MARGIN - SEL_MARK_LENGTH,
							SEL_MARK_WD,
							SEL_MARK_LENGTH,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
	ri = m_scene->addRect(	px + CELL_WD - SEL_MARK_LENGTH - SEL_MARK_MARGIN,
							py + CELL_WD - SEL_MARK_MARGIN - SEL_MARK_WD,
							SEL_MARK_LENGTH,
							SEL_MARK_WD,
							QPen(Qt::red),
							QBrush(QColor("red")));
	m_srcMarks.push_back(ri);
}
bool MainWindow::setDstMarks(int src)
{
	//m_dstList.clear();
	clearDstMarks();
	int px, py;
	bool bCanMove = false;
	//const bool canBearOff = isBlackTurn() ? m_board->canBlackBearOff()
	//											: m_board->canWhiteBearOff();
	for(int i = 0; i < 2; ++i) {
		int dst = src - m_dice[i] * m_blackTurn;
		if( m_dice[i] != 0 && canMove(src, dst) ) {
			dst = qMax(dst, (int)POINT_GOAL);
			indexToXY(dst, px, py);
			py = PIECE_Y;
			QGraphicsRectItem *ri = m_scene->addRect(
									px + DST_MARK_MARGIN,
									py + DST_MARK_MARGIN,
									DST_MARK_WD,
									DST_MARK_WD,
									QPen(Qt::gray),
									QBrush(QColor("pink")));
			ri->setZValue(10);
			m_dstMarks.push_back(ri);
			m_dstList << dst;
			m_dList << m_dice[i];
			bCanMove = true;
		}
		if( m_dice[0] == m_dice[1] ) break;
	}
	if( !bCanMove ) return false;
	setSrcMarks(src);
	return true;
}
void MainWindow::on_action_Settings_triggered()
{
	///if( m_gameState != GS_INIT ) return;
	SettingsDlg aDlg;
	aDlg.setAnimationSpeed(m_animationSpeed);
	aDlg.setHumanColor(m_blackColorText);
	aDlg.setCompColor(m_whiteColorText);
	aDlg.setAutoMoveDst(m_autoMoveDst);
	aDlg.setUndoAvailable(m_undoAvailable);
	if( aDlg.exec() == QDialog::Accepted ) {
		m_animationSpeed = aDlg.animationSpeed();
		m_blackColorText = aDlg.humanColor();
		m_whiteColorText = aDlg.compColor();
		m_autoMoveDst = aDlg.autoMoveDst();
		m_undoAvailable = aDlg.undoAvailable();
		m_blackPipsItem->setBrush(QBrush(m_blackColor = QColor(m_blackColorText)));
		m_whitePipsItem->setBrush(QBrush(m_whiteColor = QColor(m_whiteColorText)));
		writeSettings();
		placePieces();
	}
}
QString statRow(const QString &name, const Statistics &stat)
{
	return QString("<tr><td>%1</td><td><b>%2</b></td><td>%3/%4 (%5%)</td></tr>\n")
		.arg(name)
		.arg(stat.m_rating)
		.arg(stat.m_winCount)
		.arg(stat.m_gameCount)
		.arg(!stat.m_gameCount ? 0 : (stat.m_winCount*1000/stat.m_gameCount)/10.0);
}
void MainWindow::on_action_Statistics_triggered()
{
	QString mess = "<table>\n";
	mess += "<tr><th></th><th>Rating</th><th>win/game (percent)</th></tr>\n";
	mess += statRow(tr("You"), m_humanStat);
	mess += statRow(tr("Mr. Advanced"), m_compStat[3]);
	mess += statRow(tr("Mr. Inermediate"), m_compStat[2]);
	mess += statRow(tr("Mr. Beginner"), m_compStat[1]);
	mess += statRow(tr("Mr. Random"), m_compStat[0]);
	mess += "</table>";
	QMessageBox::information(this, tr("Statistics"), mess);
}
void MainWindow::on_action_ClearStatistics_triggered()
{
	if( QMessageBox::question(this, "HalfGammon", tr("Are You Sure to Clear Statistics ?"),
								QMessageBox::Yes | QMessageBox::No)
				== QMessageBox::Yes )
	{
		m_humanStat = Statistics();
		for(int i = 0; i < N_LEVEL; ++i)
			m_compStat[i] = Statistics();
		writeSettings();
	}
				
}
void MainWindow::on_action_Help_triggered()
{
	QString url = "http://vivi.dyndns.org/games/HalfGammon/help.html?from=";
	url += VERSION_STR;
	QDesktopServices::openUrl(QUrl(url));
}
void MainWindow::on_action_AboutHalfGammon_triggered()
{
	QMessageBox msgBox;
	msgBox.setIconPixmap(QPixmap(":MainWindow/Resources/ayabu.png"));
	msgBox.setText(tr("<div align=center><b>HalfGammon</b> version %1</div>").arg(VERSION_STR));
#ifdef	Q_CC_MSVC
	const QString ayabu((const QChar *)L"F ");
#else
	const QString ayabu("momoshiki tsubaki");
#endif
	msgBox.setInformativeText(QString("<div align=center>Copyright (C) 2012 by N.Tsuda<br>"
								"mailto:ntsuda@master.email.ne.jp<br>"
								"<a href=\"http://vivi.dyndns.org/?from=qvi%1\">http://vivi.dyndns.org/</a><br><br>"
								"Powered by <a href=\"http://qt.nokia.com/\">Qt</a>"
								"<p>illustrated by <a href=\"http://www.pixiv.net/member.php?id=220294\">%2</a>"
								"<p>icons by <a href=\"http://www.visualpharm.com/\">VisualPharm</a></div>")
								.arg(VERSION_STR).arg(ayabu));
	msgBox.exec();
}
