#include "mainwindow.h"
#include <QtGui/QApplication>

#define		TRANSLATOR_PREFIX		"halfgammon_"

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
    app.setOrganizationName("N.Tsuda");
    app.setApplicationName("HalfGammon");

    QString appPath = app.applicationDirPath();
	QString locale = QLocale::system().name();
	QTranslator translator;
    translator.load(appPath + "/" + QString(TRANSLATOR_PREFIX) + locale);
#ifdef		_DEBUG
    bool rc = translator.load(QString(TRANSLATOR_PREFIX) + locale);
    if( !rc ) {
		qDebug() << "can't open '" << QString(TRANSLATOR_PREFIX) << locale << "'";
	}
#endif
	app.installTranslator(&translator);

	MainWindow w;
	w.show();
	return app.exec();
}
