﻿#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//----------------------------------------------------------------------
//
//			File:			"MainWindow.h"
//			Created:		26-Aug-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow クラス宣言
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	HalfGammon のライセンスは CDDL 1.0 です。
	http://opensource.org/licenses/cddl-1.0
	無保証・無サポートですが、無償で利用でき、商用アプリでもソースコードを流用することが可能です。 
	ソースコードを流用した場合、流用したファイルのライセンスは CDDL 1.0 となります。
	流用部分の著作権は HalfGammon のそれのままです。
	作者は、プログラマにとって不自由極まりないのに自由だ自由だと言い張るGPL系が嫌いなので、 
	CDDL 1.0 を選択しました。このライセンスはGPL系より再利用しやすく、GPL系とは矛盾するライセンスなので、
	HalfGammon のソースをGPL系プロジェクトで使用することはできません。

*/

#include <QtGui>
#include "ui_mainwindow.h"


class QTimer;
class QPlainTextEdit;
class QGraphicsScene;
class QGraphicsView;
class QGraphicsRectItem;
class QGraphicsSimpleTextItem;
class QGraphicsEllipseItem;
class Board;
class TreeSearch;
class QNetworkAccessManager;
class QNetworkReply;
struct Move;

/*

                        ┌─┬─┬─┬─┐
                      ●│  │  │  │  │
                        └─┴─┴─┴─┘
            ●→                                      ←○
      ┏━┳━┯━┯━┳━┯━┯━┳━┯━┯━┳━┯━┯━┳━┓
      ┃Ｓ┃  │  │  ┃  │  │  ┃  │  │  ┃  │  │  ┃Ｓ┃
      ┃Ｇ┃  │  │  ┃  │  │  ┃  │  │  ┃  │  │  ┃Ｇ┃
      ┗━┻━┷━┷━┻━┷━┷━┻━┷━┷━┻━┷━┷━┻━┛
 point: 13  12  11  10  ９  ８  ７  ６  ５  ４  ３  ２  １  ０


*/

struct Statistics
{
	int		m_rating;
	int		m_point;
	int		m_winCount;
	int		m_gameCount;
public:
	Statistics()
		: m_rating(1500)
		, m_point(0)
		, m_winCount(0)
		, m_gameCount(0)
		{}
};

struct MoveRecord
{
	uchar	m_src;
	uchar	m_dst;
	//bool	m_hit;

public:
	MoveRecord(uchar src = 0, uchar dst = 0)
		: m_src(src)
		, m_dst(dst)
		//, m_hit(false)
	{
	}
};
//	１ターン履歴
struct TurnRecord
{
	int		m_dice1;
	int		m_dice2;
	MoveRecord	m_mvs[4];	//	ゾロ目で無い場合、m_mvs[2], [3].m_src, m_dst がゼロ
public:
	TurnRecord()
		: m_dice1(0)
		, m_dice2(0)
	{}
};

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	enum {
		GS_INIT = 0,		//	初期状態
		GS_NEW_GAME,		//	ゲーム開始
		GS_INIT_ROLLING_DICE,	//	ダイス値更処理 初期化
		GS_ROLLING_DICE,	//	ダイス値更新処理中
		GS_HUMAN_ROLL,		//	ダイスを振る（クリックする）のを待つ
		GS_END_ROLLING_DICE,	//	ダイス確定
		GS_INIT_HUMAN_SRC,	//	移動する石の選択待ち状態 初期化
		GS_HUMAN_SRC,		//	移動する石の選択待ち状態
		GS_HUMAN_DST,		//	移動先を選択待ち状態
		GS_WAIT_FOR_DECIDED,	//	ターン終了 or undo を待つ
		GS_INIT_MOVING_PIECE,
		GS_MOVING_PIECE,
		GS_MOVING_PIECE_FINISHED,
		GS_INIT_COMP_TURN,		//	コンピュータ手番初期化
		GS_COMP_TURN,
		GS_COMP_SEARCHING,
		GS_RECORD_LOADING,

		N_LEVEL = 4,

		N_DICE = 3,
		N_CELL = N_DICE * 4,			//	フィールドの数

		IX_START = N_CELL + 1,
		IX_GOAL = 0,
		POINT_BLACK_START = N_CELL + 1,		//	左端
		POINT_BLACK_GOAL = 0,				//	右端
		POINT_WHITE_START = 0,				//	右端
		POINT_WHITE_GOAL = N_CELL + 1,		//	左端

		CELL_WD = 56,
		CELL_HT = CELL_WD * 4,
		DICE_WD = CELL_WD - 8,
		DICE_MARGIN = (CELL_WD - DICE_WD) /2,
		DICE_X = CELL_WD * 3 + DICE_MARGIN,
		DICE_Y = 0,
		DICE_NUM_Y = DICE_Y - 2,
		NAME_X = CELL_WD * 6,
		NAME_WD = CELL_WD * 2,
		PIP_X = CELL_WD * 9,
		PIP_Y = DICE_Y,
		PIP_Y2 = PIP_Y + CELL_WD / 2,
		ORG_X = 0,					//	盤面原点位置
		ORG_Y = CELL_WD,
		PIECE_Y = ORG_Y + CELL_WD * 3,		//	1個目の石の位置
		PIECE_MARGIN = CELL_WD / 10,
		PIECE_WD = CELL_WD - PIECE_MARGIN * 2,
	};

public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

public slots:
	void	clearStatistics();
	void	statisticsText(QString &text);
	void	statisticsTextList(QList<QStringList> &text);

protected:
	int		pointToPx(int p) const { return (POINT_BLACK_START - p) * CELL_WD; }
	int		ixToPx(int ix) const { return ix * CELL_WD; }
	int		xyToPoint(int, int) const;
	void	pointToXY(int, int &, int &) const;
	int		xyToIndex(int, int) const;
	void	indexToXY(int, int &, int &) const;
	bool	isBlackTurn() const { return m_blackTurn > 0; }
	bool	canMove(int src, int dst) const;
	bool	isForcedMoveDest() const;

protected:
	void	createDockWindows();
	void	doOutput(const QString &);		//	アウトプットペインにテキスト出力
    void	readSettings();
    void	writeSettings();
    QGraphicsEllipseItem	*addCircle(qreal, qreal, qreal,
    									const QPen &, const QBrush &,
    									QGraphicsItem * = 0);
	void	addEyebrow(qreal, qreal, qreal, QGraphicsItem *);
	void	setupBoardItems();		//	石以外のアイテムを配置
	void	placePieces();			//	m_board を参照し、石を配置
	void	placeMovesItem(const TurnRecord &);		//	着手を曲線矢印で表現
	QGraphicsItem	*addPiece(int, int, bool, int=20, QString = QString());
	QGraphicsItem	*findPiece(int px, int py);
	QGraphicsItem	*findPiece(int ix);
	void	clearPieces();
	void	setupSrcMarks();
	void	setSrcMarks(int, bool = true);
	bool	setDstMarks(int);
	void	clearSrcMarks();
	void	clearDstMarks();
	void	removeDice(int);
	void	addDice(int);
	void	updateDice();
	void	updateDiceItems();
	bool	isPossibleToMove();		//	移動可能かどうか等をチェック
	void	updateNextItem();
	void	newGame();
	void	onStateChanged();
	void	whiteTurn();
	void	updateRating(int &, int &);
	bool	confirmToTerminate();
	void	doExit();
	void	sound(const QString &);
	void	appendToRecord(const TurnRecord &);
	void	updateMoveRecord();		//	着手履歴更新
	void	eval_playD(int rdepth);
	void	clearOutput();
	void	onGameOver(QString &, int);
	void	onBlackWin(QString &, bool = false);
	void	onWhiteWin(QString &, bool = false);

protected slots:
	void	onTimer();
	void	onSearchFinished(double);
    void	replyFinished(QNetworkReply* reply);
    void	currentRowChanged(int);

protected:
	void	mousePressEvent ( QMouseEvent * event );
	void	keyPressEvent ( QKeyEvent * e );
	void	closeEvent(QCloseEvent *event);

private slots:
    void on_action_Exit_triggered();
    void on_action_NewGame_triggered();
    void on_action_Resign_triggered();
    void on_action_Undo_triggered();
    void on_action_LoadRecord_triggered();
    void on_action_SaveRecord_triggered();
    void on_action_Start_triggered();
    void on_action_End_triggered();
    void on_action_Backward_triggered();
    void on_action_Forward_triggered();
    void on_action_Settings_triggered();
    void on_action_Statistics_triggered();
    void on_action_ClearStatistics_triggered();
    //void on_action_Help_triggered();
    void on_action_Rule_triggered();
    void on_action_HowToPlay_triggered();
    void on_action_AboutHalfGammon_triggered();
    void on_action_Eval_ply1_triggered();
    void on_action_Eval_ply2_triggered();
    void on_action_Eval_ply3_triggered();
    void on_action_Eval_ply4_triggered();
    void on_action_MonteCarlo_triggered();

private:
	Ui::MainWindowClass ui;
	bool	m_firstMoveBlack;
	bool	m_undoAvailable;
	bool	m_jumpMove;
	bool	m_MonteCarlo;
	int		m_gameMode;
	uchar	m_compType;
	uchar	m_comp2Type;
	uchar	m_gameState;
	uchar	m_nextGameState;	//	石移動終了等の後の次の状態
	Statistics	m_humanStat;
	Statistics	m_guestStat;
	Statistics	m_compStat[N_LEVEL];
#if 0
	int		m_winCount;
	int		m_gameCount;
	int		m_humanRating;		//	人間のレーティング
	int		m_compRating[3];	//	コンピュータレーティング
#endif
	int		m_blackTurn;		//	1 for BLACK, -1 for WHITE
	int		m_turn;
	int		m_dice[4];			//	サイコロの出目
	int		m_srcPoint;			//	移動する石のあるマス目ポイント
	int		m_dstPoint;			//	移動先インデックス
	int		m_d;				//	移動に使用中ダイスの目
	int		m_srcPx;
	int		m_srcPy;
	int		m_dstPx;
	int		m_dstPy;
	int		m_animationSpeed;		//	[1, 5]
	int		m_movingProgress;		//	[0, 100]
	int		m_gameInMatch;			//	マッチ内の何試合目か [1,∞)
	int		m_blackWinInMatch;		//	マッチ内黒勝利数
	int		m_blackPointInMatch;	//	マッチ内獲得ポイント
	int		m_whitePointInMatch;	//	マッチ内獲得ポイント
	bool	m_movingHumanPiece;
	//bool	m_hit;						//	ヒットされた石がある
	bool	m_autoMoveDst;				//	選択された石の移動先が一箇所の場合は、自動移動
	QList<Move>	m_compMove;				//	選択されたコンピュータの着手
	QList<Board>	m_boardHist;		//	for undo
	QList<int>		m_diceHist;			//	for undo
	QThread		*m_thread;				//	バックグラウンド探索用スレッド
	TreeSearch	*m_treeSearch;			//	木探索オブジェクト
	QString		m_blackColorText;
	QString		m_whiteColorText;
	QColor		m_blackColor;
	QColor		m_whiteColor;
	Board		*m_board;
	QList<TurnRecord>	m_turnRecord;	//	サイコロの出目、着手履歴
	TurnRecord	m_curTurn;				//	現ターンの情報
	int			m_curTurnMvIX;			//	現ターンの何て目か [0, 3]
	QTimer		*m_timer;
	QTime		m_rollDiceTime;			//	サイコロローリング開始タイム
	QTime		m_initCompTurnTime;		//	コンピュータ思考開始タイム
	QPlainTextEdit	*m_output;			//	出力ペインウィジット
	QDialog			*m_actDialog;
	QListWidget			*m_recordView;		//	棋譜
    QNetworkAccessManager	*m_networkAccessManager;
	QGraphicsScene	*m_scene;
	QGraphicsView	*m_view;
	QGraphicsItem	*m_nextItem;
	QGraphicsItem	*m_movingItem;		//	移動中石アイテム
	QGraphicsItem	*m_hitItem;			//	ヒットされた石アイテム
	QGraphicsEllipseItem	*m_blackPipsItem;
	QGraphicsEllipseItem	*m_whitePipsItem;
	QGraphicsRectItem		*m_diceRect1;
	QGraphicsRectItem		*m_diceRect2;
	QList<QGraphicsSimpleTextItem *>	m_diceItems;
	QList<int>		m_dstList;					//	移動先リスト
	QList<int>		m_dList;					//	ダイス目リスト
	QList<QGraphicsRectItem *>	m_srcMarks;		//	移動元マーク
	QList<QGraphicsRectItem *>	m_dstMarks;		//	移動先マーク
	QList<QGraphicsItem *>		m_pieces;		//	石アイテムへのポインタ
	QList<QGraphicsItem *>		m_movesItems;	//	着手アイテムへのポインタ
	QGraphicsSimpleTextItem		*m_blackNameTextItem;
	QGraphicsSimpleTextItem		*m_whiteNameTextItem;
	QGraphicsSimpleTextItem		*m_blackPipsTextItem;
	QGraphicsSimpleTextItem		*m_whitePipsTextItem;
};

#endif // MAINWINDOW_H
