/*!
* @file Species.h
* @brief Q[̃N[`[ʂ̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "GameElement.h"
#include "BaseStatusTable.h"
#include "HaveSize.h"
#include "HaveSymbol.h"

#pragma once

namespace Deeangband
{

	/*!
	* @class Species
	* @brief N[`[ʂ̃NX
	*/
	class Species : public GameElement, public HaveSymbol, public HaveSize
	{

	private:

		SOUL baseSoul; //!< {\E

		FEED baseFeed; //!< {{l
		LEVEL divineLevel; //!< {_x

		TAG baseCamp; //!< {wc

		BaseStatusTable baseStatus; //!< {Xe[^X

		std::map<TAG, SKILL_EXP> skillExpList; //!< XLolXg

		NUMBER currentCreationNumber; //!< ݐ
		NUMBER currentDeadNumber; //!< ݎS
		NUMBER maxCreationNumber; //!< ő吶

		TAG baseFirstRace; //!< {푰^O1
		TAG baseSecondRace; //!< {푰^O2

		std::vector<TAG> authorityTags; //!< \^Oz

		friend class boost::serialization::access;
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & BOOST_SERIALIZATION_BASE_OBJECT_NVP(GameElement);
				archive & BOOST_SERIALIZATION_BASE_OBJECT_NVP(HaveSymbol);
				archive & BOOST_SERIALIZATION_BASE_OBJECT_NVP(HaveSize);
				archive & boost::serialization::make_nvp("BaseFirstRace", baseFirstRace);
				archive & boost::serialization::make_nvp("BaseSecondRace", baseSecondRace);
				archive & boost::serialization::make_nvp("BaseSoul", baseSoul);
				archive & boost::serialization::make_nvp("BaseFeed", baseFeed);
				archive & boost::serialization::make_nvp("DivineLevel", divineLevel);
				archive & boost::serialization::make_nvp("BaseCamp", baseCamp);
				archive & boost::serialization::make_nvp("BaseStatus", baseStatus);
			}
		}

	public:

		/*! 
		* @brief SpeciesNXRXgN^
		*/
		Species::Species(void);

		/*! 
		* @brief SpeciesNXfXgN^
		*/
		Species::~Species(void);

		/*! 
		* @brief f[^
		*/
		void Species::WipeData(void);

		/*! 
		* @brief N[`[ʂ̊{\EʂA
		* @return \E
		*/
		SOUL Species::GetBaseSoul(void);

		/*! 
		* @brief N[`[ʂ̊{{xԂ
		* @return {{x
		*/
		FEED Species::GetBaseFeed(void);

		/*! 
		* @brief N[`[ʂ̃XL{olԂ
		* @param tag 擾XL̃^O
		* @return YXL̊{olAS̖oȂ0Ԃ
		*/
		SKILL_EXP Species::GetSkillExp(TAG tag);

		/*! 
		* @brief N[`[ʂ̊{wcԂ
		* @return {wc̃^O
		*/
		TAG Species::GetBaseCampTAG(void);

		/*! 
		* @brief \̈ꗗԂ
		* @return \ꗗvector
		*/
		std::vector<TAG> GetAuthorityTags(void);

		/*! 
		* @brief 푰̃^OԂ
		* @return 푰̃^O
		*/
		TAG GetFirstRaceTag(void);

		/*! 
		* @brief 푰̃^OԂ
		* @return 푰̃^O
		*/
		TAG GetSecondtRaceTag(void);

	};

}

BOOST_CLASS_VERSION(Deeangband::Species, 10);
