/*!
* @file HavePosition.h
* @brief V{ێۃNX̃vg^Cv錾
* @date 2014/06/11
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Coordinates.h"
#include "Deeangband.h"

namespace Deeangband
{

	/*! 
	* @class HavePosition
	* @brief V{ێۃNX
	*/
	class HavePosition
	{
	private:

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Position", position);
				archive & boost::serialization::make_nvp("Field", field);
			}
		}

	protected:

		Coordinates position; //!< ݍW
		ID fieldID; //!< ݃tAID

	public:

		/*! 
		* @brief HavePositionNXRXgN^
		*/
		HavePosition::HavePosition(void);

		/*! 
		* @brief HavePositionNXRXgN^
		* @param coordinates W
		*/
		HavePosition::HavePosition(Coordinates *coordinates);

		/*! 
		* @brief HavePositionNXRXgN^
		* @param x xW
		* @param y yW
		*/
		HavePosition::HavePosition(int x, int y);

		/*! 
		* @brief HavePositionNXRXgN^
		* @param fieldID tB[hID
		* @param coordinates W
		*/
		HavePosition::HavePosition(ID fieldID, Coordinates *coordinates);

		/*! 
		* @brief HavePositionNXRXgN^
		* @param fieldID tB[hID
		* @param x xW
		* @param y yW
		*/
		HavePosition::HavePosition(ID fieldID, int x, int y);

		/*! 
		* @brief HavePositionNXfXgN^
		*/
		HavePosition::~HavePosition(void);

		/*! 
		* @brief HavePositionf[^
		*/
		void HavePosition::WipeData(void);

		/*!
		* @brief ݍWԂ
		* @return ݍW
		*/
		Coordinates HavePosition::GetPosition(void);

		/*!
		* @brief ݍWԂ
		* @return ݍW
		*/
		ID HavePosition::GetFieldID(void);

		/*!
		* @brief tȀWɈړ
		* @param fieldID ړtAID
		* @param x ړxW
		* @param y ړyW
		* @return ړłȂꍇ̃G[ID
		*/
		int HavePosition::Move(ID fieldID, int x, int y);

		/*!
		* @brief tȀWɈړ
		* @param fieldID ړtAID
		* @param coord ړW
		* @return ړłȂꍇ̃G[ID
		*/
		int HavePosition::Move(ID fieldID, Coordinates coord);
	};
}

BOOST_CLASS_VERSION(Deeangband::HavePosition, 10);
