
/*!
* @file HavePosition.cpp
* @brief V{ێۃNX`
* @date 2014/06/11
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "HavePosition.h"

namespace Deeangband
{
	HavePosition::HavePosition(void)
	{
		WipeData();
		return;
	}

	HavePosition::~HavePosition(void)
	{
		WipeData();
		return;
	}

	HavePosition::HavePosition(Coordinates *coordinates)
	{
		this->position = *coordinates;
		this->fieldID = 0;
		return;
	}

	HavePosition::HavePosition(int x, int y)
	{
		this->position.Set(x, y);
		this->fieldID = 0;
		return;
	}

	HavePosition::HavePosition(ID fieldID, Coordinates *coordinates)
	{
		this->position = *coordinates;
		this->fieldID = fieldID;
		return;
	}

	HavePosition::HavePosition(ID fieldID, int x, int y)
	{
		this->position.Set(x, y);
		this->fieldID = fieldID;
		return;
	}

	void HavePosition::WipeData(void)
	{
		this->position.Set(0, 0);
		this->fieldID = 0;
	}

	Coordinates HavePosition::GetPosition(void)
	{
		return this->position;
	}

	ID HavePosition::GetFieldID(void)
	{
		return this->fieldID;
	}

	int HavePosition::Move(ID fieldID, int x, int y)
	{
		this->fieldID = fieldID;
		this->position.Set(x, y);
		return 0;
	}

	int HavePosition::Move(ID fieldID, Coordinates coord)
	{
		this->Move(fieldID, coord.GetX(), coord.GetY());
		return 0;
	}

}
