/*!
* @file GameEngine.cpp
* @brief Q[GW̎
* @date 2013/12/17
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "GameEngine.h"


namespace Deeangband
{
	GameEngine::GameEngine()
	{
		gameWorld = new GameWorld();
		gameSurface = new GameSurfaceSDL(gameWorld);

		gameSurface->SetField(gameWorld->GetField(0));
		gameSurface->SetSideStatusCreature(gameWorld->GetCreature(0));

		Direction::Initialize();
	}

	PLAY_EXIT_CODE GameEngine::PlayLoop(void)
	{
		GAME_COMMAND commandID;
		PLAY_EXIT_CODE code = PLAY_EXIT_NONE;
		gameSurface->Redraw();

		while(code == PLAY_EXIT_NONE)
		{
			commandID = gameSurface->GetCommand();
			code = DoGameCommand(commandID);
		}

		return PLAY_EXIT_QUIT;
	}

	PLAY_EXIT_CODE GameEngine::DoGameCommand(GAME_COMMAND command)
	{
		Creature *playerPtr = gameWorld->GetPlayerCreature();

		switch(command)
		{
		case GAME_COMMAND_VIEW_PLAYER_STATUS:
			gameSurface->ViewCreatureStatus(gameWorld->GetCreature(0));
			break;
		case GAME_COMMAND_REDRAW:
			gameSurface->Redraw();
			break;
		case GAME_COMMAND_DEBUG_XML_SAVE:
			gameWorld->XMLSave();
			gameSurface->SystemMessage("XMLɕۑ܂B");
			break;
		case GAME_COMMAND_DEBUG_XML_LOAD:
			gameSurface->Redraw();
			gameWorld->XMLLoad();
			gameSurface->SystemMessage("XMLĂяo܂B");
			break;
		case GAME_COMMAND_EXIT:
			return PLAY_EXIT_QUIT;
			break;
		case GAME_COMMAND_NORTH:
			playerPtr->Walk(DIRECTION_NORTH);
			break;
		case GAME_COMMAND_NORTH_EAST:
			playerPtr->Walk(DIRECTION_NORTH_EAST);
			break;
		case GAME_COMMAND_EAST:
			playerPtr->Walk(DIRECTION_EAST);
			break;
		case GAME_COMMAND_SOUTH_EAST:
			playerPtr->Walk(DIRECTION_SOUTH_EAST);
			break;
		case GAME_COMMAND_SOUTH:
			playerPtr->Walk(DIRECTION_SOUTH);
			break;
		case GAME_COMMAND_SOUTH_WEST:
			playerPtr->Walk(DIRECTION_SOUTH_WEST);
			break;
		case GAME_COMMAND_WEST:
			playerPtr->Walk(DIRECTION_WEST);
			break;
		case GAME_COMMAND_NORTH_WEST:
			playerPtr->Walk(DIRECTION_NORTH_WEST);
			break;
		}
		return PLAY_EXIT_NONE;
	}

}
