/*!
* @file GameElement.cpp
* @brief Q[vf̃X[p[NX
* @date 2014/01/19
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "GameElement.h"

namespace Deeangband
{
	GameElement::GameElement(void)
	{
		this->WipeData();
		return;
	}

	GameElement::~GameElement(void)
	{
		this->WipeData();
		return;
	}

	void GameElement::WipeData(void)
	{
		this->name = "";
		this->description = "";
		this->validGenerated = false;
	}

	NAME GameElement::GetName()
	{
		return this->name;
	}

	DESCRIPTION GameElement::GetDescription()
	{
		return this->description;
	}

	bool GameElement::IsValidGenerated(void)
	{
		return this->validGenerated;
	}

	std::string GameElement::WeightFormat(WEIGHT weight)
	{
		char buf[20];
		sprintf_s(buf, "%6.1fkg", weight);
		return std::string(&buf[0]);
	}

	std::string GameElement::HeightFormat(HEIGHT height)
	{
		char buf[20];
		sprintf_s(buf, "%6.2fm", height / 100.0f);
		return std::string(&buf[0]);
	}

}