package saccubus.conv;

import java.io.*;
import java.util.EnumSet;
import java.util.Set;
import org.xml.sax.*;
import javax.xml.parsers.*;

/**
 * <p>
 * タイトル: さきゅばす
 * </p>
 *
 * <p>
 * 説明: ニコニコ動画の動画をコメントつきで保存
 * </p>
 *
 * <p>
 * 著作権: Copyright (c) 2007 PSI
 * </p>
 *
 * <p>
 * 会社名:
 * </p>
 *
 * @author 未入力
 * @version 1.0
 */
public final class ConvertToVideoHook {

    private ConvertToVideoHook() {
    }

    @Deprecated
    public static void convert(File file, File out, String ng_id, String ng_word) throws IOException {
        convert(EnumSet.allOf(CommentType.class), file, out, ng_id, ng_word);
    }

    public static void convert(Set<CommentType> types, File file, File out, String ng_id, String ng_word)
            throws IOException {
        try {
            final Packet packet = new Packet();
            // SAXパーサーファクトリを生成
            final SAXParserFactory spfactory = SAXParserFactory.newInstance();
            // SAXパーサーを生成
            final SAXParser parser = spfactory.newSAXParser();
            // XMLファイルを指定されたデフォルトハンドラーで処理します
            final NicoXMLReader nico_reader = new NicoXMLReader(types, packet, ng_id, ng_word);

            parser.parse(file, nico_reader);

            try (final FileOutputStream fos = new FileOutputStream(out)) {
                packet.write(fos);
            }
        } catch (IOException | SAXException | ParserConfigurationException ex) {
            throw new IOException("コメント変換に失敗。ファイル名に使用できない文字が含まれているか正規表現の間違い？", ex);
        }
    }
}
