package saccubus.conv;

/**
 * 処理するコメントの種別.
 */
public enum CommentType {

    /** 通常のコメント. */
    NORMAL(false, false) {

        @Override
        public String getVhookOptionPrefix() {
            return "--data-user:";
        }

        @Override
        public String toString() {
            return "通常コメント";
        }
    },
    /** 投稿者コメント. */
    OWNER(true, false) {

        @Override
        public String getVhookOptionPrefix() {
            return "--data-owner:";
        }

        @Override
        public String toString() {
            return "投稿者コメント";
        }
    },
    /** オプショナルスレッドコメント. */
    OPTIONAL(false, true) {

        @Override
        public String getVhookOptionPrefix() {
            return "--data-optional:";
        }

        @Override
        public String toString() {
            return "オプショナルコメント";
        }
    },
    /** オプショナルスレッド投稿者コメント. */
    OPTIONAL_OWNER(true, true) {

        @Override
        public String getVhookOptionPrefix() {
            return "--data-owner-opt:";
        }

        @Override
        public String toString() {
            return "オプショナル投稿者コメント";
        }
    };
    private final boolean owner;
    private final boolean optional;

    private CommentType(boolean owner, boolean optional) {
        this.owner = owner;
        this.optional = optional;
    }

    public abstract String getVhookOptionPrefix();

    static CommentType valueOf(boolean owner, boolean optional) {
        if (!optional) {
            if (!owner) {
                return NORMAL;
            } else {
                return OWNER;
            }
        } else {
            if (!owner) {
                return OPTIONAL;
            } else {
                return OPTIONAL_OWNER;
            }
        }
    }

    boolean isOwner() {
        return owner;
    }

    boolean isOptional() {
        return optional;
    }
}
