/* $Id$ */
package nicobrowser.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Test;
import static org.junit.Assert.*;

public class UtilTest {

    static final String OK_MAIL = "niconico.senyou@live.jp";
    static final String OK_PASS = "piyopiyo";

    /**
     * Test of getExtention method, of class Util.
     */
    @Test
    public void testGetExtention() {
        System.out.println("getExtention");
        String result;
        result = Util.getExtention("video/x-flv");
        assertEquals("flv", result);

        result = Util.getExtention("video/flv");
        assertEquals("flv", result);

        result = Util.getExtention("video/mp4");
        assertEquals("mp4", result);

        result = Util.getExtention("application/x-shockwave-flash");
        assertEquals("swf", result);

        result = Util.getExtention("");
        assertEquals("txt", result);
    }

//    /**
//     * Test of getNextPage method, of class Util.
//     */
//    @Test
//    public void testGetNextPage() throws FileNotFoundException, MalformedURLException {
//        System.out.println("getNextPage");
//
//        InputStream is;
//        String result;
//
//        // 次のページがある場合
//        is = new FileInputStream("test_data/momiji.html");
//        result = Util.getOtherPages(is);
//        assertEquals("http://www.nicovideo.jp/search/%E7%B4%85%E8%91%89?page=2", result);
//
//        // 最終ページ
//        is = new FileInputStream("test_data/momiji_lastpage.html");
//        result = Util.getOtherPages(is);
//        assertNull(result);
//    }

    @Test
    public void testGetUserId() throws FileNotFoundException {
        InputStream is = new FileInputStream("testdata/sm8769630.html");
        String id = Util.getUserId(is);
        assertEquals("336619", id);
    }

    @Test
    public void testGetUserName() throws FileNotFoundException {
        InputStream is = new FileInputStream("testdata/notifier.html");
        String name = Util.getUserName(is);
        assertEquals("nakano", name);
    }

    /**
     * Test of getNotifierUrl method, of class Util.
     */
    @Test
    public void testGetNotifierUrl() throws FileNotFoundException {
        InputStream is = new FileInputStream("testdata/sm8769630.html");
        URL url = Util.getNotifierUrl(is);
        assertEquals("http://www.smilevideo.jp/view/8769630/335912", url.toString());
    }
}
