/*$Id$*/
package nicobrowser.util;

import java.io.InputStream;
import java.util.List;

public class Util {

    static ResultParse rp = new ResultParse();
    static UserInfo ui = new UserInfo();

    public static String getExtention(String contentType) {
        if ("video/flv".equals(contentType) || "video/x-flv".equals(contentType)) {
            return "flv";
        } else if ("video/mp4".equals(contentType)) {
            return "mp4";
        } else if ("application/x-shockwave-flash".equals(contentType)) {
            return "swf";
        }
        return contentType.split("/")[1];
    }

    public static List<Result> parseSerchResult(InputStream is) {
        return rp.parse(is);
    }

    public static String getNextPage(InputStream is) {
        return rp.getNextPage(is);
    }

    /**
     * ユーザIDを取得する
     * @param is ニコニコ動画のウォッチページストリーム.
     * @return ユーザID.
     */
    public static String getUserId(InputStream is) {
        return ui.getUserId(is);
    }

    /**
     * ユーザ名を取得する.
     * @param is ユーザページのストリーム.
     * @return ユーザ名.
     */
    public static String getUserName(InputStream is) {
        return ui.getUserName(is);
    }
}
