/** */
package nicobrowser.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.commandline.Main;
import liquibase.exception.CommandLineParsingException;
import nicobrowser.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBUpdater {

    private static Log log = LogFactory.getLog(DBUpdater.class);
    private static final String UPDATE_FILE = "db_update_script.xml";
    private static final String SYNC_FILE = "db_for_sync_script.xml";

    public void sync() throws IOException {
        File updateFile = new File(new File(Config.getInstance().getDbFile()).getParent(), UPDATE_FILE);
        InputStream resource = ClassLoader.getSystemResourceAsStream("resources/" + SYNC_FILE);

        createFile(resource, updateFile);

        String[] args = new String[]{
            "--driver=org.h2.Driver",
            "--changeLogFile=" + updateFile.toString(),
            "--url=jdbc:h2:" + Config.getInstance().getDbFile(),
            "--username=sa",
            "changeLogSync"};
        try {
            Main.main(args);

            log.info("DBのアップデートが終了しました.");
        } catch (CommandLineParsingException ex) {
            log.fatal("DBのアップデートに失敗しました.", ex);
            throw new IOException(ex);
        }
    }

    public void update() throws IOException {
        File updateFile = new File(new File(Config.getInstance().getDbFile()).getParent(), UPDATE_FILE);
        InputStream resource = ClassLoader.getSystemResourceAsStream("resources/" + UPDATE_FILE);

        createFile(resource, updateFile);

        String[] args = new String[]{
            "--driver=org.h2.Driver",
            "--changeLogFile=" + updateFile.toString(),
            "--url=jdbc:h2:" + Config.getInstance().getDbFile(),
            "--username=sa",
            "update"};
        try {
            Main.main(args);

            log.info("DBのアップデートが終了しました.");
        } catch (CommandLineParsingException ex) {
            log.fatal("DBのアップデートに失敗しました.", ex);
            throw new IOException(ex);
        }
    }

    private void createFile(InputStream resource, File updateFile) throws IOException {
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new BufferedInputStream(resource);
            os = new BufferedOutputStream(new FileOutputStream(updateFile));
            byte[] b = new byte[1024];
            int l;
            while ((l = is.read(b)) != -1) {
                os.write(b, 0, l);
            }
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (IOException ex) {
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException ex) {
                }
            }
        }
    }
}
