/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.upload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.file.FileCleaner;
import org.apache.wicket.util.io.DeferredFileOutputStream;
import org.apache.wicket.util.upload.FileItem;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.upload.ParameterParser;

public class DiskFileItem
implements FileItem {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final int WRITE_BUFFER_SIZE = 2048;
    private static int counter = 0;
    private String fieldName;
    private final String contentType;
    private boolean isFormField;
    private final String fileName;
    private final int sizeThreshold;
    private final File repository;
    private byte[] cachedContent;
    private DeferredFileOutputStream dfos;

    public DiskFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.dfos.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(this.getContentType(), ';');
        return (String)params.get("charset");
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] get() {
        if (this.dfos.isInMemory()) {
            if (this.cachedContent != null) return this.cachedContent;
            this.cachedContent = this.dfos.getData();
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        fis = new FileInputStream(this.dfos.getFile());
        fis.read(fileData);
        Object var5_3 = null;
        if (fis == null) return fileData;
        try {
            fis.close();
            return fileData;
        }
        catch (IOException e2) {}
        return fileData;
        {
            catch (IOException e) {
                fileData = null;
                Object var5_4 = null;
                if (fis == null) return fileData;
                try {
                    fis.close();
                    return fileData;
                }
                catch (IOException e2) {}
                return fileData;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), charset);
    }

    public String getString() {
        byte[] rawdata = this.get();
        String charset = this.getCharSet();
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(rawdata, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(rawdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws Exception {
        block19: {
            block18: {
                IOException e22;
                FilterOutputStream out;
                block17: {
                    if (this.isInMemory()) {
                        FileOutputStream fout = null;
                        try {
                            fout = new FileOutputStream(file);
                            fout.write(this.get());
                        }
                        finally {
                            if (fout != null) {
                                fout.close();
                            }
                        }
                    }
                    File outputFile = this.getStoreLocation();
                    if (outputFile == null) break block18;
                    if (outputFile.renameTo(file)) break block19;
                    BufferedInputStream in = null;
                    out = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(outputFile));
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        byte[] bytes = new byte[2048];
                        int s = 0;
                        while ((s = in.read(bytes)) != -1) {
                            ((BufferedOutputStream)out).write(bytes, 0, s);
                        }
                        Object var8_9 = null;
                        if (in == null) break block17;
                    }
                    catch (Throwable throwable) {
                        IOException e22;
                        Object var8_10 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e22) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e22) {}
                }
                break block19;
            }
            throw new FileUploadException("Cannot write uploaded file to disk!");
        }
    }

    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            File outputFile = this.getTempFile();
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, outputFile);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos.getFile();
    }

    protected void finalize() {
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    protected File getTempFile() {
        File tempDir = this.repository;
        if (tempDir == null) {
            String systemTmp = null;
            try {
                systemTmp = System.getProperty("java.io.tmpdir");
            }
            catch (SecurityException e) {
                throw new WicketRuntimeException("Reading property java.io.tmpdir is not allowed for the current security settings. The repository location needs to be set manually, or upgrade permissions to allow reading the tmpdir property.");
            }
            tempDir = new File(systemTmp);
        }
        String fileName = "upload_" + DiskFileItem.getUniqueId() + ".tmp";
        File f = new File(tempDir, fileName);
        FileCleaner.track(f, (Object)this);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        int current;
        Class clazz = DiskFileItem.class;
        synchronized (clazz) {
            current = counter++;
        }
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    public String toString() {
        return "name=" + this.getName() + ", StoreLocation=" + String.valueOf(this.getStoreLocation()) + ", size=" + this.getSize() + "bytes, " + "isFormField=" + this.isFormField() + ", FieldName=" + this.getFieldName();
    }
}

