/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.util.Map;
import org.apache.wicket.behavior.StringHeaderContributor;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.template.CssTemplate;
import org.apache.wicket.util.template.JavaScriptTemplate;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;

public class TextTemplateHeaderContributor
extends StringHeaderContributor {
    private static final long serialVersionUID = 1L;

    public static TextTemplateHeaderContributor forCss(TextTemplate template, IModel variablesModel) {
        return new TextTemplateHeaderContributor(new CssTemplate(template), variablesModel);
    }

    public static TextTemplateHeaderContributor forCss(Class clazz, String fileName, IModel variablesModel) {
        return TextTemplateHeaderContributor.forCss(new PackagedTextTemplate(clazz, fileName), variablesModel);
    }

    public static TextTemplateHeaderContributor forJavaScript(TextTemplate template, IModel variablesModel) {
        return new TextTemplateHeaderContributor(new JavaScriptTemplate(template), variablesModel);
    }

    public static TextTemplateHeaderContributor forJavaScript(Class clazz, String fileName, IModel variablesModel) {
        return TextTemplateHeaderContributor.forJavaScript(new PackagedTextTemplate(clazz, fileName), variablesModel);
    }

    protected TextTemplateHeaderContributor(TextTemplate template, IModel variablesModel) {
        super(new TemplateModel(template, variablesModel));
    }

    private static final class TemplateModel
    extends LoadableDetachableModel {
        private static final long serialVersionUID = 1L;
        private final TextTemplate template;
        private final IModel variablesModel;

        protected TemplateModel(TextTemplate template, IModel variablesModel) {
            if (template == null) {
                throw new IllegalArgumentException("argument template must be not null");
            }
            this.template = template;
            this.variablesModel = variablesModel;
        }

        public void detach() {
            if (this.variablesModel != null) {
                this.variablesModel.detach();
            }
            super.detach();
        }

        protected Object load() {
            Map variables;
            if (this.variablesModel != null && (variables = (Map)this.variablesModel.getObject()) != null) {
                return this.template.asString(variables);
            }
            return this.template.asString();
        }
    }
}

