/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wicket.WicketRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Streams {
    private static final String XML_PROPERTIES_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int byteCount;
        byte[] buffer = new byte[4096];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    public static void loadFromXml(Properties properties, InputStream inputStream) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            int i;
            DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    if (systemId.equals("http://java.sun.com/dtd/properties.dtd")) {
                        InputSource inputSource = new InputSource(new StringReader(Streams.XML_PROPERTIES_DTD));
                        inputSource.setSystemId("http://java.sun.com/dtd/properties.dtd");
                        return inputSource;
                    }
                    throw new SAXException("Invalid system identifier: " + systemId);
                }
            });
            db.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            InputSource is = new InputSource(inputStream);
            Document doc = db.parse(is);
            NodeList entries = ((Element)doc.getChildNodes().item(1)).getChildNodes();
            int len = entries.getLength();
            int n = i = len > 0 && entries.item(0).getNodeName().equals("comment") ? 1 : 0;
            while (i < len) {
                Element entry = (Element)entries.item(i);
                if (entry.hasAttribute("key")) {
                    Node node = entry.getFirstChild();
                    String val = node == null ? "" : node.getNodeValue();
                    properties.setProperty(entry.getAttribute("key"), val);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            throw new WicketRuntimeException(e);
        }
        catch (SAXException e) {
            throw new WicketRuntimeException("invalid XML properties format", e);
        }
    }

    public static String readString(InputStream in) throws IOException {
        return Streams.readString(new BufferedReader(new InputStreamReader(in)));
    }

    public static String readString(InputStream in, CharSequence encoding) throws IOException {
        return Streams.readString(new BufferedReader(new InputStreamReader(in, ((Object)encoding).toString())));
    }

    public static String readString(Reader in) throws IOException {
        int value;
        StringBuffer buffer = new StringBuffer(2048);
        while ((value = in.read()) != -1) {
            buffer.append((char)value);
        }
        return buffer.toString();
    }

    private Streams() {
    }
}

