/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.security.SecureRandom;
import javax.servlet.http.HttpSession;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.SunJceCrypt;

public class KeyInSessionSunJceCryptFactory
implements ICryptFactory {
    private static SecureRandom numberGenerator;

    public ICrypt newCrypt() {
        String keyAttr;
        WebRequestCycle rc = (WebRequestCycle)RequestCycle.get();
        HttpSession session = rc.getWebRequest().getHttpServletRequest().getSession(true);
        String key = (String)session.getAttribute(keyAttr = rc.getApplication().getApplicationKey() + "." + this.getClass().getName());
        if (key == null) {
            key = session.getId() + "." + KeyInSessionSunJceCryptFactory.randomUUIDString();
            session.setAttribute(keyAttr, (Object)key);
        }
        SunJceCrypt crypt = new SunJceCrypt();
        crypt.setKey(key);
        return crypt;
    }

    private static String randomUUIDString() {
        int i;
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        for (i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return KeyInSessionSunJceCryptFactory.digits(mostSigBits >> 32, 8) + "-" + KeyInSessionSunJceCryptFactory.digits(mostSigBits >> 16, 4) + "-" + KeyInSessionSunJceCryptFactory.digits(mostSigBits, 4) + "-" + KeyInSessionSunJceCryptFactory.digits(leastSigBits >> 48, 4) + "-" + KeyInSessionSunJceCryptFactory.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

