/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert;

import java.text.Format;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Classes;

public class ConversionException
extends WicketRuntimeException {
    private static final long serialVersionUID = 1L;
    private IConverter converter;
    private Format format;
    private Locale locale;
    private Object sourceValue;
    private String targetTypeName;
    private String resourceKey;
    private Map vars;

    public ConversionException(String message) {
        super(message);
    }

    public ConversionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConversionException(Throwable cause) {
        super(cause);
    }

    public final IConverter getConverter() {
        return this.converter;
    }

    public final Format getFormat() {
        return this.format;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Object getSourceValue() {
        return this.sourceValue;
    }

    public final Class getTargetType() {
        return Classes.resolveClass(this.targetTypeName);
    }

    public final ConversionException setConverter(IConverter converter) {
        this.converter = converter;
        return this;
    }

    public final ConversionException setFormat(Format format) {
        this.format = format;
        return this;
    }

    public final ConversionException setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public final ConversionException setSourceValue(Object sourceValue) {
        this.sourceValue = sourceValue;
        return this;
    }

    public final ConversionException setTargetType(Class targetType) {
        this.targetTypeName = targetType.getName();
        return this;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public ConversionException setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    public ConversionException setVariable(String name, Object value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Argument [[name]] cannot be null or an empty string");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument [[value]] cannot be null or an empty string");
        }
        if (this.vars == null) {
            this.vars = new HashMap(2);
        }
        this.vars.put(name, value);
        return this;
    }

    public Map getVariables() {
        return this.vars;
    }
}

