/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component;

import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.target.component.IPageRequestTarget;

public class PageRequestTarget
implements IPageRequestTarget {
    private final Page page;

    public PageRequestTarget(Page page) {
        if (page == null) {
            throw new IllegalArgumentException("Argument page must be not null");
        }
        this.page = page;
    }

    public void respond(RequestCycle requestCycle) {
        if (requestCycle.isRedirect()) {
            requestCycle.redirectTo(this.page);
        } else {
            this.page.renderPage();
        }
    }

    public final Page getPage() {
        return this.page;
    }

    public void detach(RequestCycle requestCycle) {
        this.page.detach();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PageRequestTarget) {
            PageRequestTarget that = (PageRequestTarget)obj;
            return this.page.equals(that.page);
        }
        return false;
    }

    public int hashCode() {
        int result = "PageRequestTarget".hashCode();
        return 17 * (result += this.page.hashCode());
    }

    public String toString() {
        return "[PageRequestTarget@" + this.hashCode() + " page=" + this.page + "]";
    }
}

