/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.basic;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.wicket.Application;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;

public class StringRequestTarget
implements IRequestTarget {
    private final String string;
    private final String contentType;
    private final String encoding;

    public StringRequestTarget(String string) {
        this("text/plain", StringRequestTarget.getDefaultEncoding(), string);
    }

    public StringRequestTarget(String contentType, String encoding, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument string must be not null");
        }
        if (Strings.isEmpty(contentType)) {
            throw new IllegalArgumentException("Argument contentType must not be null or empty");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument charset must not be null");
        }
        this.contentType = contentType;
        this.string = string;
        this.encoding = encoding;
    }

    public StringRequestTarget(String contentType, Charset charset, String string) {
        this(contentType, charset.aliases().iterator().next(), string);
    }

    private static String getDefaultEncoding() {
        return Application.get().getRequestCycleSettings().getResponseRequestEncoding();
    }

    public void respond(RequestCycle requestCycle) {
        Response response = requestCycle.getResponse();
        response.setContentType(this.contentType + ";charset=" + this.encoding);
        try {
            response.getOutputStream().write(this.string.getBytes(this.encoding));
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to render string: " + e.getMessage(), e);
        }
    }

    public void detach(RequestCycle requestCycle) {
    }

    public String getString() {
        return this.string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringRequestTarget) {
            StringRequestTarget that = (StringRequestTarget)obj;
            return this.string.equals(that.string);
        }
        return false;
    }

    public int hashCode() {
        int result = "StringRequestTarget".hashCode();
        return 17 * (result += this.string.hashCode());
    }

    public String toString() {
        return "[StringRequestTarget@" + this.hashCode() + " " + this.string + "]";
    }
}

