/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.portals.bridges.common.PortletResourceURLFactory;
import org.apache.portals.bridges.common.ServletContextProvider;
import org.apache.wicket.protocol.http.portlet.WicketResponseState;

public class WicketPortlet
extends GenericPortlet {
    public static final String WICKET_URL_PORTLET_PARAMETER = "_wu";
    public static final String PORTLET_RESOURCE_URL_PARAMETER = "_ru";
    public static final String PORTLET_RESOURCE_URL_ATTR = "_ru";
    public static final String WICKET_FILTER_PATH_PARAM = "wicketFilterPath";
    public static final String PARAM_SERVLET_CONTEXT_PROVIDER = "ServletContextProvider";
    public static final String PARAM_PORTLET_RESOURCE_URL_FACTORY = "PortletResourceURLFactory";
    public static final String ACTION_REQUEST = "ACTION";
    public static final String VIEW_REQUEST = "VIEW";
    public static final String RESOURCE_REQUEST = "RESOURCE";
    public static final String CUSTOM_REQUEST = "CUSTOM";
    public static final String EDIT_REQUEST = "EDIT";
    public static final String HELP_REQUEST = "HELP";
    public static final String REQUEST_TYPE_ATTR = WicketPortlet.class.getName() + ".REQUEST_TYPE";
    public static final String WICKET_URL_PORTLET_PARAMETER_ATTR = WicketPortlet.class.getName() + ".WICKET_URL_PORTLET_PARAMETER";
    public static final String CONFIG_PARAM_PREFIX = WicketPortlet.class.getName() + ".";
    public static final String RESPONSE_STATE_ATTR = WicketResponseState.class.getName();
    public static final String RESOURCE_URL_FACTORY_ATTR = PortletResourceURLFactory.class.getName();
    public static final String WICKET_PORTLET_PROPERTIES = WicketPortlet.class.getName().replace('.', '/') + ".properties";
    public static final String WICKET_FILTER_PATH = WicketPortlet.class.getName() + ".FILTERPATH";
    public static final String WICKET_FILTER_QUERY = WicketPortlet.class.getName() + ".FILTERQUERY";
    public static final String PARAM_ACTION_PAGE = "actionPage";
    public static final String PARAM_CUSTOM_PAGE = "customPage";
    public static final String PARAM_EDIT_PAGE = "editPage";
    public static final String PARAM_HELP_PAGE = "helpPage";
    public static final String PARAM_VIEW_PAGE = "viewPage";
    private ServletContextProvider servletContextProvider;
    private PortletResourceURLFactory resourceURLFactory;
    private String wicketFilterPath;
    private String wicketFilterQuery;
    private final HashMap defaultPages = new HashMap();

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        Properties wicketPortletProperties = null;
        String contextProviderClassName = this.getContextProviderClassNameParameter(config);
        if (contextProviderClassName == null) {
            contextProviderClassName = config.getPortletContext().getInitParameter(ServletContextProvider.class.getName());
        }
        if (contextProviderClassName == null) {
            wicketPortletProperties = this.getWicketPortletProperties(wicketPortletProperties);
            contextProviderClassName = wicketPortletProperties.getProperty(ServletContextProvider.class.getName());
        }
        if (contextProviderClassName == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PARAM_SERVLET_CONTEXT_PROVIDER + " not specified, nor as context parameter " + ServletContextProvider.class.getName() + " or as property in " + WICKET_PORTLET_PROPERTIES + " in the classpath.");
        }
        try {
            Class<?> clazz = Class.forName(contextProviderClassName);
            this.servletContextProvider = (ServletContextProvider)clazz.newInstance();
        }
        catch (Exception e) {
            if (e instanceof PortletException) {
                throw (PortletException)((Object)e);
            }
            throw new PortletException("Initialization failure", (Throwable)e);
        }
        String resourceURLFactoryClassName = this.getPortletResourceURLFactoryClassNameParameter(config);
        if (resourceURLFactoryClassName == null) {
            resourceURLFactoryClassName = config.getPortletContext().getInitParameter(PortletResourceURLFactory.class.getName());
        }
        if (resourceURLFactoryClassName == null) {
            wicketPortletProperties = this.getWicketPortletProperties(wicketPortletProperties);
            resourceURLFactoryClassName = wicketPortletProperties.getProperty(PortletResourceURLFactory.class.getName());
        }
        if (resourceURLFactoryClassName == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PARAM_PORTLET_RESOURCE_URL_FACTORY + " not specified, nor as context parameter " + PortletResourceURLFactory.class.getName() + " or as property in " + WICKET_PORTLET_PROPERTIES + " in the classpath.");
        }
        try {
            Class<?> clazz = Class.forName(resourceURLFactoryClassName);
            this.resourceURLFactory = (PortletResourceURLFactory)clazz.newInstance();
        }
        catch (Exception e) {
            if (e instanceof PortletException) {
                throw (PortletException)((Object)e);
            }
            throw new PortletException("Initialization failure", (Throwable)e);
        }
        this.wicketFilterPath = this.buildWicketFilterPath(config.getInitParameter(WICKET_FILTER_PATH_PARAM));
        this.wicketFilterQuery = this.buildWicketFilterQuery(this.wicketFilterPath);
        this.defaultPages.put(PARAM_VIEW_PAGE, config.getInitParameter(PARAM_VIEW_PAGE));
        this.defaultPages.put(PARAM_ACTION_PAGE, config.getInitParameter(PARAM_ACTION_PAGE));
        this.defaultPages.put(PARAM_CUSTOM_PAGE, config.getInitParameter(PARAM_CUSTOM_PAGE));
        this.defaultPages.put(PARAM_HELP_PAGE, config.getInitParameter(PARAM_HELP_PAGE));
        this.defaultPages.put(PARAM_EDIT_PAGE, config.getInitParameter(PARAM_EDIT_PAGE));
        this.validateDefaultPages(this.defaultPages, this.wicketFilterPath, this.wicketFilterQuery);
    }

    public void destroy() {
        this.resourceURLFactory = null;
        this.servletContextProvider = null;
        super.destroy();
    }

    protected String getDefaultPage(String pageType) {
        return (String)this.defaultPages.get(pageType);
    }

    protected String buildWicketFilterPath(String filterPath) {
        if (filterPath == null || filterPath.length() == 0) {
            filterPath = "/";
        } else {
            if (!filterPath.startsWith("/")) {
                filterPath = "/" + filterPath;
            }
            if (filterPath.endsWith("*")) {
                filterPath = filterPath.substring(0, filterPath.length() - 1);
            }
            if (!filterPath.endsWith("/")) {
                filterPath = filterPath + "/";
            }
        }
        return filterPath;
    }

    protected String buildWicketFilterQuery(String wicketFilterPath) {
        if (wicketFilterPath.equals("/")) {
            return "?";
        }
        return wicketFilterPath.substring(0, wicketFilterPath.length() - 1) + "?";
    }

    protected String fixWicketUrl(String url, String wicketFilterPath, String wicketFilterQuery) {
        if (url == null) {
            return wicketFilterPath;
        }
        if (!url.startsWith(wicketFilterPath)) {
            if ((url + "/").equals(wicketFilterPath)) {
                url = wicketFilterPath;
            } else if (url.startsWith(wicketFilterQuery)) {
                url = wicketFilterPath + "?" + url.substring(wicketFilterQuery.length());
            }
        }
        return url;
    }

    protected void validateDefaultPages(Map defaultPages, String wicketFilterPath, String wicketFilterQuery) {
        String viewPage = this.fixWicketUrl((String)defaultPages.get(PARAM_VIEW_PAGE), wicketFilterPath, wicketFilterQuery);
        defaultPages.put(PARAM_VIEW_PAGE, viewPage.startsWith(wicketFilterPath) ? viewPage : wicketFilterPath);
        String defaultPage = (String)defaultPages.get(PARAM_ACTION_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_ACTION_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_ACTION_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = (String)defaultPages.get(PARAM_CUSTOM_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_CUSTOM_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_CUSTOM_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = (String)defaultPages.get(PARAM_HELP_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_HELP_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_HELP_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = (String)defaultPages.get(PARAM_EDIT_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_EDIT_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_EDIT_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
    }

    protected Properties getWicketPortletProperties(Properties properties) throws PortletException {
        InputStream is;
        if (properties == null) {
            properties = new Properties();
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(WICKET_PORTLET_PROPERTIES)) != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new PortletException("Failed to load WicketPortlet.properties from classpath", (Throwable)e);
            }
        }
        return properties;
    }

    protected String getContextProviderClassNameParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_SERVLET_CONTEXT_PROVIDER);
    }

    protected String getPortletResourceURLFactoryClassNameParameter(PortletConfig config) {
        return config.getInitParameter(PARAM_PORTLET_RESOURCE_URL_FACTORY);
    }

    protected ServletContextProvider getServletContextProvider() {
        return this.servletContextProvider;
    }

    protected ServletContext getServletContext(GenericPortlet portlet, PortletRequest request, PortletResponse response) {
        return this.getServletContextProvider().getServletContext(portlet);
    }

    protected HttpServletRequest getHttpServletRequest(GenericPortlet portlet, PortletRequest request, PortletResponse response) {
        return this.getServletContextProvider().getHttpServletRequest(portlet, request);
    }

    protected HttpServletResponse getHttpServletResponse(GenericPortlet portlet, PortletRequest request, PortletResponse response) {
        return this.getServletContextProvider().getHttpServletResponse(portlet, response);
    }

    protected String getWicketConfigParameter(PortletRequest request, String paramName, String defaultValue) {
        return defaultValue;
    }

    protected String getWicketUrlPortletParameter(PortletRequest request) {
        return WICKET_URL_PORTLET_PARAMETER;
    }

    protected String getWicketFilterPath() {
        return this.wicketFilterPath;
    }

    protected String getWicketURL(PortletRequest request, String pageType, String defaultPage) {
        String wicketURL = null;
        wicketURL = request instanceof ActionRequest ? request.getParameter((String)request.getAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR)) : request.getParameter((String)request.getAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR) + request.getPortletMode().toString());
        if (wicketURL == null) {
            wicketURL = this.getWicketConfigParameter(request, CONFIG_PARAM_PREFIX + pageType, defaultPage);
        }
        return wicketURL;
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, VIEW_REQUEST, PARAM_VIEW_PAGE);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, EDIT_REQUEST, PARAM_EDIT_PAGE);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, HELP_REQUEST, PARAM_HELP_PAGE);
    }

    protected void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, CUSTOM_REQUEST, PARAM_CUSTOM_PAGE);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, ACTION_REQUEST, PARAM_ACTION_PAGE);
    }

    protected void processRequest(PortletRequest request, PortletResponse response, String requestType, String pageType) throws PortletException, IOException {
        String wicketURL = null;
        String wicketFilterPath = null;
        String wicketFilterQuery = null;
        request.setAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR, (Object)this.getWicketUrlPortletParameter(request));
        wicketURL = this.getWicketURL(request, pageType, this.getDefaultPage(pageType));
        wicketFilterPath = this.getWicketConfigParameter(request, WICKET_FILTER_PATH, this.wicketFilterPath);
        wicketFilterQuery = this.getWicketConfigParameter(request, WICKET_FILTER_QUERY, this.wicketFilterQuery);
        boolean actionRequest = ACTION_REQUEST.equals(requestType);
        WicketResponseState responseState = new WicketResponseState();
        request.setAttribute(RESPONSE_STATE_ATTR, (Object)responseState);
        request.setAttribute(RESOURCE_URL_FACTORY_ATTR, (Object)this.resourceURLFactory);
        request.setAttribute(REQUEST_TYPE_ATTR, (Object)requestType);
        String portletResourceURL = request.getParameter("_ru");
        if (portletResourceURL != null) {
            request.setAttribute("_ru", (Object)portletResourceURL);
        }
        if (actionRequest) {
            ServletContext servletContext = this.getServletContext(this, request, response);
            HttpServletRequest req = this.getHttpServletRequest(this, request, response);
            HttpServletResponse res = this.getHttpServletResponse(this, request, response);
            RequestDispatcher rd = servletContext.getRequestDispatcher(wicketURL);
            if (rd != null) {
                if (req.getAttribute("javax.portlet.config") == null) {
                    req.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
                }
                if (req.getAttribute("javax.portlet.request") == null) {
                    req.setAttribute("javax.portlet.request", (Object)request);
                }
                if (req.getAttribute("javax.portlet.response") == null) {
                    req.setAttribute("javax.portlet.response", (Object)response);
                }
                try {
                    rd.include((ServletRequest)req, (ServletResponse)res);
                    this.processActionResponseState(wicketURL, wicketFilterPath, wicketFilterQuery, (ActionRequest)request, (ActionResponse)response, responseState);
                }
                catch (ServletException e) {
                    throw new PortletException((Throwable)e);
                }
            }
        } else {
            PortletRequestDispatcher rd = null;
            String previousURL = null;
            while ((rd = this.getPortletContext().getRequestDispatcher(wicketURL)) != null) {
                rd.include((RenderRequest)request, (RenderResponse)response);
                String redirectLocation = responseState.getRedirectLocation();
                if (redirectLocation == null) break;
                redirectLocation = this.fixWicketUrl(redirectLocation, wicketFilterPath, wicketFilterQuery);
                boolean validWicketUrl = redirectLocation.startsWith(wicketFilterPath);
                if (portletResourceURL != null) {
                    if (validWicketUrl) {
                        HashMap<String, String[]> parameters = new HashMap<String, String[]>(2);
                        parameters.put((String)request.getAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR) + request.getPortletMode().toString(), new String[]{redirectLocation});
                        parameters.put("_ru", new String[]{"true"});
                        redirectLocation = this.resourceURLFactory.createResourceURL(this.getPortletConfig(), (RenderRequest)request, (RenderResponse)response, parameters);
                    }
                    this.getHttpServletResponse(this, request, response).sendRedirect(redirectLocation);
                    break;
                }
                if (!validWicketUrl || previousURL != null && previousURL == redirectLocation) break;
                previousURL = wicketURL;
                wicketURL = redirectLocation;
                ((RenderResponse)response).reset();
                responseState.reset();
            }
        }
    }

    protected void processActionResponseState(String wicketURL, String wicketFilterPath, String wicketFilterQuery, ActionRequest request, ActionResponse response, WicketResponseState responseState) throws PortletException, IOException {
        if (responseState.getRedirectLocation() != null) {
            wicketURL = this.fixWicketUrl(responseState.getRedirectLocation(), wicketFilterPath, wicketFilterQuery);
            if (wicketURL.startsWith(wicketFilterPath)) {
                response.setRenderParameter((String)request.getAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR) + request.getPortletMode().toString(), wicketURL);
            } else {
                response.sendRedirect(responseState.getRedirectLocation());
            }
        }
    }
}

