/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelPool {
    private final Map nameToChannel = new HashMap();
    private final Map channelToName = new HashMap();
    private final Map channelToUseCount = new HashMap();
    private final LinkedList idleChannels = new LinkedList();
    private final Set channelsToDeleteOnReturn = new HashSet();
    private final int capacity;
    private static final Logger log = LoggerFactory.getLogger((Class)FileChannelPool.class);

    public FileChannelPool(int capacity) {
        this.capacity = capacity;
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least one.");
        }
        log.debug("Starting file channel pool with capacity of " + capacity + " channels");
    }

    private FileChannel newFileChannel(String fileName, boolean createIfDoesNotExist) {
        File file = new File(fileName);
        if (!file.exists() && !createIfDoesNotExist) {
            return null;
        }
        try {
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            return channel;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void reduceChannels() {
        int channelsToReduce;
        for (channelsToReduce = this.nameToChannel.size() - this.capacity + 1; channelsToReduce > 0 && !this.idleChannels.isEmpty(); --channelsToReduce) {
            FileChannel channel = (FileChannel)this.idleChannels.getFirst();
            String channelName = (String)this.channelToName.get(channel);
            this.idleChannels.removeFirst();
            this.nameToChannel.remove(channelName);
            this.channelToName.remove(channel);
            if (this.channelToUseCount.get(channel) != null) {
                log.warn("Channel " + channelName + " is both idle and in use at the same time!");
                this.channelToUseCount.remove(channel);
            }
            try {
                channel.close();
                continue;
            }
            catch (IOException e) {
                log.error("Error closing file channel", (Throwable)e);
            }
        }
        if (channelsToReduce > 0) {
            log.warn("Unable to reduce enough channels, no idle channels left to remove.");
        }
    }

    public synchronized FileChannel getFileChannel(String fileName, boolean createIfDoesNotExist) {
        FileChannel channel = (FileChannel)this.nameToChannel.get(fileName);
        if (channel == null && (channel = this.newFileChannel(fileName, createIfDoesNotExist)) != null) {
            if (this.nameToChannel.size() >= this.capacity) {
                this.reduceChannels();
            }
            this.nameToChannel.put(fileName, channel);
            this.channelToName.put(channel, fileName);
        }
        if (channel != null) {
            Integer count = (Integer)this.channelToUseCount.get(channel);
            if (count == null || count == 0) {
                this.channelToUseCount.put(channel, new Integer(1));
                this.idleChannels.remove(channel);
            } else {
                count = new Integer(count + 1);
                this.channelToUseCount.put(channel, count);
            }
        }
        return channel;
    }

    public synchronized void returnFileChannel(FileChannel channel) {
        Integer count = (Integer)this.channelToUseCount.get(channel);
        if (count == null || count == 0) {
            throw new IllegalArgumentException("Trying to return unused channel");
        }
        if ((count = new Integer(count - 1)) == 0) {
            this.channelToUseCount.remove(channel);
            if (this.channelsToDeleteOnReturn.contains(channel)) {
                this.closeAndDelete(channel);
            } else {
                this.idleChannels.addLast(channel);
            }
        } else {
            this.channelToUseCount.put(channel, count);
        }
    }

    private void closeAndDelete(FileChannel channel) {
        this.channelsToDeleteOnReturn.remove(channel);
        String name = (String)this.channelToName.get(channel);
        this.channelToName.remove(channel);
        this.channelToUseCount.remove(channel);
        this.idleChannels.remove(channel);
        try {
            channel.close();
        }
        catch (IOException e) {
            log.error("Error closing file channel", (Throwable)e);
        }
        File file = new File(name);
        file.delete();
    }

    public synchronized void closeAndDeleteFileChannel(String name) {
        FileChannel channel = (FileChannel)this.nameToChannel.get(name);
        if (channel != null) {
            this.nameToChannel.remove(name);
            Integer count = (Integer)this.channelToUseCount.get(channel);
            if (count != null && count > 0) {
                this.channelsToDeleteOnReturn.add(channel);
            } else {
                this.closeAndDelete(channel);
            }
        } else {
            File file = new File(name);
            file.delete();
        }
    }

    public synchronized void destroy() {
        log.debug("Destroying FileChannel pool");
        Iterator i = this.channelToName.keySet().iterator();
        while (i.hasNext()) {
            FileChannel channel = (FileChannel)i.next();
            try {
                channel.close();
            }
            catch (IOException e) {
                log.error("Error closing file channel", (Throwable)e);
            }
        }
    }
}

