/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResponse
extends Response {
    private static final Logger log = LoggerFactory.getLogger((Class)WebResponse.class);
    protected boolean redirect;
    private final HttpServletResponse httpServletResponse;
    private boolean ajax;

    public WebResponse() {
        this.httpServletResponse = null;
    }

    public WebResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public void addCookie(Cookie cookie) {
        if (this.httpServletResponse != null) {
            this.httpServletResponse.addCookie(cookie);
        }
    }

    public void clearCookie(Cookie cookie) {
        if (this.httpServletResponse != null) {
            cookie.setMaxAge(0);
            cookie.setValue(null);
            this.addCookie(cookie);
        }
    }

    public void close() {
    }

    public CharSequence encodeURL(CharSequence url) {
        if (this.httpServletResponse != null && url != null) {
            if (url.length() > 0 && url.charAt(0) == '?') {
                String encoded = this.httpServletResponse.encodeURL("./" + ((Object)url).toString());
                if (encoded.startsWith("./")) {
                    return encoded.substring(2);
                }
                return encoded;
            }
            return this.httpServletResponse.encodeURL(((Object)url).toString());
        }
        return url;
    }

    public final HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public OutputStream getOutputStream() {
        try {
            return this.httpServletResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Error while getting output stream.", e);
        }
    }

    public final boolean isRedirect() {
        return this.redirect;
    }

    public void redirect(String url) {
        if (!this.redirect) {
            if (this.httpServletResponse != null) {
                url = this.httpServletResponse.encodeRedirectURL(url);
                try {
                    if (this.httpServletResponse.isCommitted()) {
                        log.error("Unable to redirect to: " + url + ", HTTP Response has already been committed.");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Redirecting to " + url);
                    }
                    if (this.isAjax()) {
                        this.httpServletResponse.addHeader("Ajax-Location", url);
                        this.httpServletResponse.getWriter().write(" ");
                    } else {
                        this.httpServletResponse.sendRedirect(url);
                    }
                    this.redirect = true;
                }
                catch (IOException e) {
                    log.warn("redirect to " + url + " failed: " + e.getMessage());
                }
            }
        } else {
            log.info("Already redirecting to an url current one ignored: " + url);
        }
    }

    public final void setContentType(String mimeType) {
        if (this.httpServletResponse != null) {
            this.httpServletResponse.setContentType(mimeType);
        }
    }

    public void setContentLength(long length) {
        if (this.httpServletResponse != null) {
            this.httpServletResponse.setContentLength((int)length);
        }
    }

    public void setLastModifiedTime(Time time) {
        if (this.httpServletResponse != null && time != null && time.getMilliseconds() != -1L) {
            this.httpServletResponse.setDateHeader("Last-Modified", time.getMilliseconds());
        }
    }

    public final void setLocale(Locale locale) {
        if (this.httpServletResponse != null) {
            this.httpServletResponse.setLocale(locale);
        }
    }

    public void write(CharSequence string) {
        if (string instanceof AppendingStringBuffer) {
            this.write((AppendingStringBuffer)string);
        } else {
            if (string instanceof StringBuffer) {
                try {
                    StringBuffer sb = (StringBuffer)string;
                    char[] array = new char[sb.length()];
                    sb.getChars(0, sb.length(), array, 0);
                    this.httpServletResponse.getWriter().write(array, 0, array.length);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException("Error while writing to servlet output writer.", e);
                }
            }
            try {
                this.httpServletResponse.getWriter().write(((Object)string).toString());
            }
            catch (IOException e) {
                throw new WicketRuntimeException("Error while writing to servlet output writer.", e);
            }
        }
    }

    public void write(AppendingStringBuffer asb) {
        try {
            this.httpServletResponse.getWriter().write(asb.getValue(), 0, asb.length());
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Error while writing to servlet output writer.", e);
        }
    }

    public void setDateHeader(String header, long date) {
        if (this.httpServletResponse != null) {
            this.httpServletResponse.setDateHeader(header, date);
        }
    }

    public void setHeader(String header, String value) {
        if (this.httpServletResponse != null) {
            this.httpServletResponse.setHeader(header, value);
        }
    }

    public void setAttachmentHeader(String filename) {
        this.setHeader("Content-Disposition", "attachment" + (!Strings.isEmpty(filename) ? "; filename=\"" + filename + "\"" : ""));
    }

    public boolean isAjax() {
        return this.ajax;
    }

    public void setAjax(boolean ajax) {
        this.ajax = ajax;
    }
}

