/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;

public class ResourceModel
extends AbstractReadOnlyModel
implements IComponentAssignedModel {
    private static final long serialVersionUID = 1L;
    private final String resourceKey;
    private final String defaultValue;

    public ResourceModel(String resourceKey) {
        this(resourceKey, null);
    }

    public ResourceModel(String resourceKey, String defaultValue) {
        this.resourceKey = resourceKey;
        this.defaultValue = defaultValue;
    }

    public Object getObject() {
        return Application.get().getResourceSettings().getLocalizer().getString(this.resourceKey, (Component)null, this.defaultValue);
    }

    public IWrapModel wrapOnAssignment(Component component) {
        return new AssignmentWrapper(this.resourceKey, this.defaultValue, component);
    }

    private class AssignmentWrapper
    extends ResourceModel
    implements IWrapModel {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(String resourceKey, String defaultValue, Component component) {
            super(resourceKey, defaultValue);
            this.component = component;
        }

        public IModel getWrappedModel() {
            return ResourceModel.this;
        }

        public Object getObject() {
            return Application.get().getResourceSettings().getLocalizer().getString(ResourceModel.this.resourceKey, this.component, ResourceModel.this.defaultValue);
        }

        public void detach() {
            super.detach();
            ResourceModel.this.detach();
        }
    }
}

