/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.IChainingModel;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class CompoundPropertyModel
implements IComponentInheritedModel,
IChainingModel {
    private static final long serialVersionUID = 1L;
    private Object target;

    public CompoundPropertyModel(Object object) {
        this.target = object;
    }

    public Object getObject() {
        if (this.target instanceof IModel) {
            return ((IModel)this.target).getObject();
        }
        return this.target;
    }

    public void setObject(Object object) {
        if (this.target instanceof IModel) {
            ((IModel)this.target).setObject(object);
        } else {
            this.target = object;
        }
    }

    public IModel getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    public void setChainedModel(IModel model) {
        this.target = model;
    }

    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    protected String propertyExpression(Component component) {
        return component.getId();
    }

    public IWrapModel wrapOnInheritance(Component component) {
        return new AttachedCompoundPropertyModel(component);
    }

    public IModel bind(String property) {
        return new PropertyModel(this, property);
    }

    public String toString() {
        AppendingStringBuffer sb = new AppendingStringBuffer().append("Model:classname=[" + this.getClass().getName() + "]");
        sb.append(":nestedModel=[").append(this.target).append("]");
        return sb.toString();
    }

    public final Object getObject(Component component) {
        throw new UnsupportedOperationException();
    }

    public final void setObject(Component component, Object object) {
        throw new UnsupportedOperationException();
    }

    private class AttachedCompoundPropertyModel
    extends AbstractPropertyModel
    implements IWrapModel {
        private static final long serialVersionUID = 1L;
        private final Component owner;

        public AttachedCompoundPropertyModel(Component owner) {
            super(CompoundPropertyModel.this);
            this.owner = owner;
        }

        protected String propertyExpression() {
            return CompoundPropertyModel.this.propertyExpression(this.owner);
        }

        public IModel getWrappedModel() {
            return CompoundPropertyModel.this;
        }

        public void detach() {
            super.detach();
            CompoundPropertyModel.this.detach();
        }
    }
}

